<?= $this->extend('layouts/admin') ?>

<?= $this->section('content') ?>
<style>
    .admin-header {
        background: white;
        padding: 2rem;
        border-radius: 15px;
        margin-bottom: 2rem;
        box-shadow: 0 5px 20px rgba(0,0,0,0.05);
        display: flex;
        justify-content: space-between;
        align-items: center;
        flex-wrap: wrap;
        gap: 1rem;
    }
    .alert-success {
        background: #d1fae5;
        color: #065f46;
        padding: 1rem;
        border-radius: 10px;
        margin-bottom: 1rem;
        border: 1px solid #a7f3d0;
    }
</style>

<?php
    $search      = $search ?? '';
    $filterField = $filterField ?? '';
    $filterValue = $filterValue ?? '';
    $sortBy      = $sortBy ?? 'tanggal';
    $sortDir     = $sortDir ?? 'desc';
    $pageParam   = $pageParam ?? 'page_aktivitas';

    $buildSortUrl = function (string $column) use ($search, $filterField, $filterValue, $sortBy, $sortDir, $pageParam) {
        $direction = ($sortBy === $column && $sortDir === 'asc') ? 'desc' : 'asc';
        $params    = array_filter([
            'search'       => $search,
            'filter_field' => $filterField,
            'filter_value' => $filterValue,
            'sort_by'      => $column,
            'sort_dir'     => $direction,
            $pageParam     => 1,
        ], 'strlen');

        return current_url() . '?' . http_build_query($params);
    };

    $sortIcon = function (string $column) use ($sortBy, $sortDir) {
        if ($sortBy !== $column) {
            return '<i class="fas fa-sort" aria-hidden="true"></i>';
        }

        return $sortDir === 'asc'
            ? '<i class="fas fa-arrow-up" aria-hidden="true"></i>'
            : '<i class="fas fa-arrow-down" aria-hidden="true"></i>';
    };

    $totalRows = isset($pager) ? $pager->getTotal('aktivitas') : count($aktivitas ?? []);
?>

<section style="padding-top: 100px;">
    <div class="container">
        <div class="admin-header">
            <h1><i class="fas fa-calendar-check"></i> Kelola Aktivitas</h1>
            <div>
                <a href="<?= base_url('admin') ?>" class="btn" style="padding: 10px 20px; margin-right: 10px;">
                    <i class="fas fa-arrow-left"></i> Kembali
                </a>
                <a href="<?= base_url('admin/aktivitas/create') ?>" class="btn" style="padding: 10px 20px;">
                    <i class="fas fa-plus"></i> Tambah Aktivitas
                </a>
            </div>
        </div>

        <?php if (session()->getFlashdata('success')): ?>
        <div class="alert-success">
            <i class="fas fa-check-circle"></i> <?= session()->getFlashdata('success') ?>
        </div>
        <?php endif; ?>

        <div class="filter-section">
            <form method="GET" class="filter-form">
                <div class="form-group">
                    <label for="search-aktivitas">Pencarian</label>
                    <input id="search-aktivitas" type="text" name="search" class="form-control" placeholder="Cari aktivitas, deskripsi, jenis..." value="<?= esc($search) ?>">
                </div>
                <div class="form-group">
                    <label for="filter-field">Filter kolom</label>
                    <select id="filter-field" name="filter_field" class="form-control">
                        <option value="">Semua kolom</option>
                        <option value="nama_aktivitas" <?= $filterField === 'nama_aktivitas' ? 'selected' : '' ?>>Nama Aktivitas</option>
                        <option value="jenis" <?= $filterField === 'jenis' ? 'selected' : '' ?>>Jenis</option>
                        <option value="tanggal" <?= $filterField === 'tanggal' ? 'selected' : '' ?>>Tanggal</option>
                    </select>
                </div>
                <div class="form-group">
                    <label for="filter-value">Nilai filter</label>
                    <input id="filter-value" type="text" name="filter_value" class="form-control" placeholder="Misal: foto, video, 2024-01-01" value="<?= esc($filterValue) ?>">
                </div>
                <div class="form-group">
                    <label for="sort-by">Urutkan</label>
                    <select id="sort-by" name="sort_by" class="form-control">
                        <option value="id" <?= $sortBy === 'id' ? 'selected' : '' ?>>ID</option>
                        <option value="nama_aktivitas" <?= $sortBy === 'nama_aktivitas' ? 'selected' : '' ?>>Nama Aktivitas</option>
                        <option value="tanggal" <?= $sortBy === 'tanggal' ? 'selected' : '' ?>>Tanggal</option>
                        <option value="jam" <?= $sortBy === 'jam' ? 'selected' : '' ?>>Jam</option>
                        <option value="jenis" <?= $sortBy === 'jenis' ? 'selected' : '' ?>>Jenis</option>
                        <option value="created_at" <?= $sortBy === 'created_at' ? 'selected' : '' ?>>Tanggal dibuat</option>
                    </select>
                </div>
                <div class="form-group">
                    <label for="sort-dir">Arah urutan</label>
                    <select id="sort-dir" name="sort_dir" class="form-control">
                        <option value="asc" <?= $sortDir === 'asc' ? 'selected' : '' ?>>Naik (A-Z / 0-9)</option>
                        <option value="desc" <?= $sortDir === 'desc' ? 'selected' : '' ?>>Turun (Z-A / 9-0)</option>
                    </select>
                </div>
                <div class="form-group">
                    <label>&nbsp;</label>
                    <div style="display: flex; gap: 0.5rem; flex-wrap: wrap;">
                        <button type="submit" class="btn" style="padding: 10px 20px;">Terapkan</button>
                        <a href="<?= current_url() ?>" class="btn secondary" style="padding: 10px 20px;">Reset</a>
                    </div>
                </div>
            </form>
            <div class="muted" style="margin-top: 0.5rem;">
                Menampilkan <?= count($aktivitas ?? []) ?> dari <?= $totalRows ?> data (10 per halaman)
            </div>
        </div>

        <div class="table-container">
            <table>
                <thead>
                    <tr>
                        <th>
                            <a href="<?= $buildSortUrl('id') ?>" style="color: inherit; text-decoration: none; display: inline-flex; align-items: center; gap: 0.35rem;">
                                ID <?= $sortIcon('id') ?>
                            </a>
                        </th>
                        <th>
                            <a href="<?= $buildSortUrl('nama_aktivitas') ?>" style="color: inherit; text-decoration: none; display: inline-flex; align-items: center; gap: 0.35rem;">
                                Nama Aktivitas <?= $sortIcon('nama_aktivitas') ?>
                            </a>
                        </th>
                        <th>
                            <a href="<?= $buildSortUrl('tanggal') ?>" style="color: inherit; text-decoration: none; display: inline-flex; align-items: center; gap: 0.35rem;">
                                Tanggal <?= $sortIcon('tanggal') ?>
                            </a>
                        </th>
                        <th>
                            <a href="<?= $buildSortUrl('jam') ?>" style="color: inherit; text-decoration: none; display: inline-flex; align-items: center; gap: 0.35rem;">
                                Jam <?= $sortIcon('jam') ?>
                            </a>
                        </th>
                        <th>
                            <a href="<?= $buildSortUrl('jenis') ?>" style="color: inherit; text-decoration: none; display: inline-flex; align-items: center; gap: 0.35rem;">
                                Jenis <?= $sortIcon('jenis') ?>
                            </a>
                        </th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (!empty($aktivitas)): ?>
                        <?php foreach ($aktivitas as $item): ?>
                        <tr>
                            <td><?= esc($item['id']) ?></td>
                            <td><?= esc($item['nama_aktivitas']) ?></td>
                            <td><?= $item['tanggal'] ? date('d/m/Y', strtotime($item['tanggal'])) : '-' ?></td>
                            <td><?= $item['jam'] ? date('H:i', strtotime($item['jam'])) : '-' ?></td>
                            <td>
                                <span style="padding: 5px 10px; border-radius: 5px; background: <?= $item['jenis'] === 'foto' ? '#3b82f6' : '#ef4444' ?>; color: white;">
                                    <?= esc($item['jenis']) ?>
                                </span>
                            </td>
                            <td>
                                <a href="<?= base_url('admin/aktivitas/edit/' . $item['id']) ?>" class="btn" style="padding: 5px 15px; font-size: 0.9rem; margin-right: 5px;">
                                    <i class="fas fa-edit"></i> Edit
                                </a>
                                <form method="POST" action="<?= base_url('admin/aktivitas/delete/' . $item['id']) ?>" style="display:inline;">
                                    <?= csrf_field() ?>
                                    <button type="submit" class="btn" style="padding: 5px 15px; font-size: 0.9rem; background: #ef4444;" onclick="return confirm('Yakin ingin menghapus?')">
                                        <i class="fas fa-trash"></i> Hapus
                                    </button>
                                </form>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="6" style="text-align: center; padding: 2rem; color: #64748b;">
                                Belum ada data aktivitas
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <?php if (isset($pager)): ?>
        <div class="pagination">
            <?= $pager->links('aktivitas', 'default_full') ?>
        </div>
        <?php endif; ?>
    </div>
</section>
<?= $this->endSection() ?>
