-- Database Schema untuk Aplikasi Portofolio
-- Buat database terlebih dahulu: CREATE DATABASE db_portofolio;

USE db_portofolio;

-- Tabel Biodata/CV
CREATE TABLE biodata (
    id INT AUTO_INCREMENT PRIMARY KEY,
    nama VARCHAR(100) NOT NULL,
    email VARCHAR(100) NOT NULL,
    telepon VARCHAR(20),
    alamat TEXT,
    tanggal_lahir DATE,
    tempat_lahir VARCHAR(100),
    jenis_kelamin ENUM('L', 'P'),
    agama VARCHAR(50),
    status_pernikahan VARCHAR(50),
    keahlian TEXT,
    deskripsi TEXT,
    foto VARCHAR(255),
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);

-- Tabel Riwayat Pendidikan
CREATE TABLE riwayat_pendidikan (
    id INT AUTO_INCREMENT PRIMARY KEY,
    jenjang ENUM('SD', 'SMP', 'SMA', 'D3', 'S1', 'S2', 'S3') NOT NULL,
    nama_sekolah VARCHAR(200) NOT NULL,
    jurusan VARCHAR(100),
    tahun_masuk YEAR NOT NULL,
    tahun_lulus YEAR,
    nilai_akhir VARCHAR(10),
    prestasi TEXT,
    alamat_sekolah TEXT,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);

-- Tabel Aktivitas Harian
CREATE TABLE aktivitas_harian (
    id INT AUTO_INCREMENT PRIMARY KEY,
    tanggal DATE NOT NULL,
    jam TIME NOT NULL,
    nama_aktivitas VARCHAR(200) NOT NULL,
    deskripsi TEXT,
    foto VARCHAR(255),
    video VARCHAR(255),
    kategori VARCHAR(100),
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);

-- Insert sample data
INSERT INTO biodata (nama, email, telepon, alamat, tanggal_lahir, tempat_lahir, jenis_kelamin, agama, status_pernikahan, keahlian, deskripsi) VALUES
('John Doe', 'john@example.com', '081234567890', 'Jl. Contoh No. 123, Jakarta', '1995-05-15', 'Jakarta', 'L', 'Islam', 'Belum Menikah', 'Web Development, Mobile Development, Database Design', 'Seorang developer yang berpengalaman dalam pengembangan aplikasi web dan mobile.');

INSERT INTO riwayat_pendidikan (jenjang, nama_sekolah, jurusan, tahun_masuk, tahun_lulus, nilai_akhir, prestasi) VALUES
('SD', 'SDN 01 Jakarta', NULL, 2001, 2007, '85.5', 'Juara 1 Olimpiade Matematika'),
('SMP', 'SMPN 5 Jakarta', NULL, 2007, 2010, '87.2', 'Ketua OSIS'),
('SMA', 'SMAN 3 Jakarta', 'IPA', 2010, 2013, '88.5', 'Juara 2 Lomba Karya Ilmiah'),
('S1', 'Universitas Yarsi', 'Teknik Informatika', 2013, 2017, '3.65', 'Cum Laude');

INSERT INTO aktivitas_harian (tanggal, jam, nama_aktivitas, deskripsi, kategori) VALUES
('2024-12-14', '08:00:00', 'Coding Project', 'Mengembangkan aplikasi web portofolio', 'Development'),
('2024-12-14', '10:30:00', 'Meeting Client', 'Diskusi requirement project baru', 'Meeting'),
('2024-12-14', '14:00:00', 'Learning', 'Belajar framework baru', 'Education'),
('2024-12-13', '09:00:00', 'Code Review', 'Review code dari tim developer', 'Development'),
('2024-12-13', '15:30:00', 'Testing', 'Testing aplikasi mobile', 'Testing');