<!DOCTYPE html>
<html lang="id" class="scroll-smooth">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $title ?? 'Admin Panel' ?></title>
    
    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- Custom CSS -->
    <style>
        .gradient-purple {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        }
        
        .sidebar-link {
            transition: all 0.3s ease;
        }
        
        .sidebar-link:hover {
            background: rgba(139, 92, 246, 0.1);
            border-left: 4px solid #8b5cf6;
        }
        
        .sidebar-link.active {
            background: rgba(139, 92, 246, 0.1);
            border-left: 4px solid #8b5cf6;
            color: #8b5cf6;
        }
        
        .card-hover {
            transition: all 0.3s ease;
        }
        
        .card-hover:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1);
        }
        
        .btn-purple {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            transition: all 0.3s ease;
        }
        
        .btn-purple:hover {
            transform: translateY(-1px);
            box-shadow: 0 5px 10px -2px rgba(0, 0, 0, 0.1);
        }
        
        .animate-fade-in {
            animation: fadeIn 0.6s ease-in-out;
        }
        
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }
    </style>
    
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        purple: {
                            50: '#f5f3ff',
                            100: '#ede9fe',
                            200: '#ddd6fe',
                            300: '#c4b5fd',
                            400: '#a78bfa',
                            500: '#8b5cf6',
                            600: '#7c3aed',
                            700: '#6d28d9',
                            800: '#5b21b6',
                            900: '#4c1d95',
                        }
                    }
                }
            }
        }
    </script>
</head>
<body class="bg-gray-100">
    <div class="flex h-screen">
        <!-- Sidebar -->
        <div class="w-64 bg-white shadow-lg">
            <div class="p-6">
                <div class="flex items-center space-x-2">
                    <div class="w-8 h-8 gradient-purple rounded-lg flex items-center justify-center">
                        <i class="fas fa-cog text-white text-sm"></i>
                    </div>
                    <span class="text-xl font-bold text-gray-800">Admin Panel</span>
                </div>
            </div>
            
            <nav class="mt-6">
                <a href="<?= base_url('/admin') ?>" class="sidebar-link flex items-center px-6 py-3 text-gray-700 border-l-4 border-transparent <?= (current_url() == base_url('/admin') || current_url() == base_url('/admin/')) ? 'active' : '' ?>">
                    <i class="fas fa-tachometer-alt mr-3"></i>
                    Dashboard
                </a>
                
                <a href="<?= base_url('/admin/biodata') ?>" class="sidebar-link flex items-center px-6 py-3 text-gray-700 border-l-4 border-transparent <?= (strpos(current_url(), 'admin/biodata') !== false) ? 'active' : '' ?>">
                    <i class="fas fa-id-card mr-3"></i>
                    Kelola Biodata
                </a>
                
                <a href="<?= base_url('/admin/pendidikan') ?>" class="sidebar-link flex items-center px-6 py-3 text-gray-700 border-l-4 border-transparent <?= (strpos(current_url(), 'admin/pendidikan') !== false) ? 'active' : '' ?>">
                    <i class="fas fa-graduation-cap mr-3"></i>
                    Kelola Pendidikan
                </a>
                
                <a href="<?= base_url('/admin/aktivitas') ?>" class="sidebar-link flex items-center px-6 py-3 text-gray-700 border-l-4 border-transparent <?= (strpos(current_url(), 'admin/aktivitas') !== false) ? 'active' : '' ?>">
                    <i class="fas fa-calendar-alt mr-3"></i>
                    Kelola Aktivitas
                </a>
                
                <div class="border-t border-gray-200 mt-6 pt-6">
                    <a href="<?= base_url('/') ?>" class="sidebar-link flex items-center px-6 py-3 text-gray-700 border-l-4 border-transparent">
                        <i class="fas fa-arrow-left mr-3"></i>
                        Kembali ke Frontend
                    </a>
                </div>
            </nav>
        </div>

        <!-- Main Content -->
        <div class="flex-1 flex flex-col overflow-hidden">
            <!-- Header -->
            <header class="bg-white shadow-sm border-b">
                <div class="flex items-center justify-between px-6 py-4">
                    <h1 class="text-2xl font-semibold text-gray-800"><?= $title ?? 'Admin Panel' ?></h1>
                    
                    <div class="flex items-center space-x-4">
                        <div class="text-sm text-gray-500">
                            <i class="fas fa-clock mr-1"></i>
                            <?= date('d M Y, H:i') ?>
                        </div>
                        
                        <div class="w-8 h-8 gradient-purple rounded-full flex items-center justify-center">
                            <i class="fas fa-user text-white text-sm"></i>
                        </div>
                    </div>
                </div>
            </header>

            <!-- Page Content -->
            <main class="flex-1 overflow-x-hidden overflow-y-auto bg-gray-100 p-6 animate-fade-in">
                <!-- Flash Messages -->
                <?php if (session()->getFlashdata('success')): ?>
                    <div class="mb-6 bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded-lg flex items-center">
                        <i class="fas fa-check-circle mr-2"></i>
                        <?= session()->getFlashdata('success') ?>
                    </div>
                <?php endif; ?>

                <?php if (session()->getFlashdata('error')): ?>
                    <div class="mb-6 bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded-lg flex items-center">
                        <i class="fas fa-exclamation-circle mr-2"></i>
                        <?= session()->getFlashdata('error') ?>
                    </div>
                <?php endif; ?>

                <?php if (session()->getFlashdata('errors')): ?>
                    <div class="mb-6 bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded-lg">
                        <div class="flex items-center mb-2">
                            <i class="fas fa-exclamation-triangle mr-2"></i>
                            <strong>Terdapat kesalahan:</strong>
                        </div>
                        <ul class="list-disc list-inside">
                            <?php foreach (session()->getFlashdata('errors') as $error): ?>
                                <li><?= $error ?></li>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                <?php endif; ?>

                <?= $this->renderSection('content') ?>
            </main>
        </div>
    </div>

    <!-- JavaScript -->
    <script>
        // Confirm delete
        function confirmDelete(url, message = 'Apakah Anda yakin ingin menghapus data ini?') {
            if (confirm(message)) {
                window.location.href = url;
            }
        }

        // Auto hide flash messages
        setTimeout(function() {
            const alerts = document.querySelectorAll('.bg-green-100, .bg-red-100');
            alerts.forEach(function(alert) {
                alert.style.transition = 'opacity 0.5s';
                alert.style.opacity = '0';
                setTimeout(function() {
                    alert.remove();
                }, 500);
            });
        }, 5000);

        // Form validation
        document.addEventListener('DOMContentLoaded', function() {
            const forms = document.querySelectorAll('form');
            forms.forEach(function(form) {
                form.addEventListener('submit', function(e) {
                    const requiredFields = form.querySelectorAll('[required]');
                    let isValid = true;
                    
                    requiredFields.forEach(function(field) {
                        if (!field.value.trim()) {
                            isValid = false;
                            field.classList.add('border-red-500');
                        } else {
                            field.classList.remove('border-red-500');
                        }
                    });
                    
                    if (!isValid) {
                        e.preventDefault();
                        alert('Mohon lengkapi semua field yang wajib diisi');
                    }
                });
            });
        });
    </script>
</body>
</html>