<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $title ?? 'My Portfolio' ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        purple: {
                            50: '#f5f3ff',
                            100: '#ede9fe',
                            200: '#ddd6fe',
                            300: '#c4b5fd',
                            400: '#a78bfa',
                            500: '#8b5cf6',
                            600: '#7c3aed',
                            700: '#6d28d9',
                            800: '#5b21b6',
                            900: '#4c1d95',
                        }
                    },
                    fontFamily: {
                        sans: ['Inter', 'sans-serif'],
                    }
                }
            }
        }
    </script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        body { font-family: 'Inter', sans-serif; }
        .glass-nav {
            background: rgba(255, 255, 255, 0.8);
            backdrop-filter: blur(10px);
            -webkit-backdrop-filter: blur(10px);
        }
    </style>
</head>
<body class="bg-purple-50 text-gray-800 antialiased min-h-screen flex flex-col">

    <!-- Navbar -->
    <nav class="fixed w-full z-50 glass-nav border-b border-purple-100 transition-all duration-300">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex justify-between h-16 items-center">
                <div class="flex-shrink-0 flex items-center">
                    <a href="/" class="text-2xl font-bold text-transparent bg-clip-text bg-gradient-to-r from-purple-600 to-purple-800 hover:opacity-80 transition-opacity">
                        Portfolio.
                    </a>
                </div>
                <div class="hidden md:flex space-x-8 items-center">
                    <a href="/" class="text-gray-600 hover:text-purple-600 font-medium transition-colors <?= current_url() == base_url() ? 'text-purple-600 font-semibold' : '' ?>">Beranda</a>
                    <a href="/biodata" class="text-gray-600 hover:text-purple-600 font-medium transition-colors <?= strpos(current_url(), 'biodata') !== false ? 'text-purple-600 font-semibold' : '' ?>">Biodata</a>
                    <a href="/education" class="text-gray-600 hover:text-purple-600 font-medium transition-colors <?= strpos(current_url(), 'education') !== false ? 'text-purple-600 font-semibold' : '' ?>">Pendidikan</a>
                    <a href="/activities" class="text-gray-600 hover:text-purple-600 font-medium transition-colors <?= strpos(current_url(), 'activities') !== false ? 'text-purple-600 font-semibold' : '' ?>">Aktivitas</a>
                    <a href="/admin" class="px-4 py-2 rounded-full bg-purple-100 text-purple-700 font-medium hover:bg-purple-200 transition-colors text-sm">
                        Masuk
                    </a>
                </div>
                <!-- Mobile menu button -->
                <div class="md:hidden flex items-center">
                    <button class="mobile-menu-button focus:outline-none">
                        <i class="fa-solid fa-bars text-xl text-gray-600"></i>
                    </button>
                </div>
            </div>
        </div>
        <!-- Mobile Menu -->
        <div class="mobile-menu hidden md:hidden bg-white border-t border-purple-100 p-4 space-y-2">
            <a href="/" class="block px-4 py-2 text-gray-700 hover:bg-purple-50 rounded-lg">Beranda</a>
            <a href="/biodata" class="block px-4 py-2 text-gray-700 hover:bg-purple-50 rounded-lg">Biodata</a>
            <a href="/education" class="block px-4 py-2 text-gray-700 hover:bg-purple-50 rounded-lg">Pendidikan</a>
            <a href="/activities" class="block px-4 py-2 text-gray-700 hover:bg-purple-50 rounded-lg">Aktivitas</a>
            <a href="/admin" class="block px-4 py-2 text-purple-600 font-medium hover:bg-purple-50 rounded-lg">Masuk</a>
        </div>
    </nav>

    <!-- Main Content -->
    <main class="flex-grow pt-24 pb-12 px-4 sm:px-6 lg:px-8 max-w-7xl mx-auto w-full">
        <?= $this->renderSection('content') ?>
    </main>

    <!-- Footer -->
    <footer class="bg-white border-t border-purple-100 mt-auto">
        <div class="max-w-7xl mx-auto py-8 px-4 sm:px-6 lg:px-8 flex flex-col md:flex-row justify-between items-center bg-white">
            <div class="text-gray-500 text-sm">
                &copy; <?= date('Y') ?> Portfolio. Hak Cipta Dilindungi.
            </div>
            <div class="flex space-x-6 mt-4 md:mt-0">
                <a href="#" class="text-gray-400 hover:text-purple-500 transition-colors"><i class="fa-brands fa-github text-xl"></i></a>
                <a href="#" class="text-gray-400 hover:text-purple-500 transition-colors"><i class="fa-brands fa-linkedin text-xl"></i></a>
                <a href="#" class="text-gray-400 hover:text-purple-500 transition-colors"><i class="fa-brands fa-instagram text-xl"></i></a>
            </div>
        </div>
    </footer>

    <script>
        const btn = document.querySelector("button.mobile-menu-button");
        const menu = document.querySelector(".mobile-menu");

        btn.addEventListener("click", () => {
            menu.classList.toggle("hidden");
        });
    </script>
</body>
</html>
