<?= $this->extend('layout/public') ?>

<?= $this->section('content') ?>

<div class="mb-10 text-center">
    <h1 class="text-3xl font-bold text-gray-900 mb-4">Riwayat Pendidikan</h1>
    <p class="text-gray-500 max-w-2xl mx-auto">Perjalanan akademis dan pencapaian pendidikan saya.</p>
</div>

<!-- Controls -->
<div class="bg-white p-4 rounded-xl shadow-sm border border-gray-100 mb-8 flex flex-col md:flex-row justify-between items-center gap-4">
    <!-- Search -->
    <form action="" method="get" class="w-full md:w-auto flex-grow max-w-lg relative">
        <input type="text" name="search" value="<?= esc($search) ?>" placeholder="Cari sekolah atau jurusan..." class="w-full pl-10 pr-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-purple-500 text-sm">
        <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none text-gray-400">
            <i class="fa-solid fa-search"></i>
        </div>
        <?php if($sort): ?><input type="hidden" name="sort" value="<?= esc($sort) ?>"><?php endif; ?>
        <?php if($order): ?><input type="hidden" name="order" value="<?= esc($order) ?>"><?php endif; ?>
    </form>
    
    <!-- Sort -->
    <div class="flex items-center space-x-2 flex-shrink-0">
        <span class="text-sm text-gray-500">Urutkan:</span>
        <a href="?sort=tahun_masuk&order=<?= $order == 'ASC' ? 'DESC' : 'ASC' ?>&search=<?= $search ?>" class="px-3 py-2 text-sm border rounded-lg hover:bg-gray-50 transition-colors <?= $sort == 'tahun_masuk' ? 'bg-purple-50 text-purple-700 border-purple-200' : 'bg-white' ?>">
            Tahun <?php if($sort == 'tahun_masuk'): ?><i class="fa-solid fa-sort-<?= $order == 'ASC' ? 'up' : 'down' ?> ml-1"></i><?php endif; ?>
        </a>
        <a href="?sort=jenjang&order=<?= $order == 'ASC' ? 'DESC' : 'ASC' ?>&search=<?= $search ?>" class="px-3 py-2 text-sm border rounded-lg hover:bg-gray-50 transition-colors <?= $sort == 'jenjang' ? 'bg-purple-50 text-purple-700 border-purple-200' : 'bg-white' ?>">
            Jenjang <?php if($sort == 'jenjang'): ?><i class="fa-solid fa-sort-<?= $order == 'ASC' ? 'up' : 'down' ?> ml-1"></i><?php endif; ?>
        </a>
    </div>
</div>

<div class="relative border-l-2 border-purple-200 ml-3 md:ml-6 space-y-8 pl-8 md:pl-12 py-4">
    <?php foreach ($education as $item) : ?>
    <div class="relative group">
        <!-- Timeline Dot -->
        <div class="absolute -left-[45px] md:-left-[61px] top-6 w-6 h-6 rounded-full border-4 border-white bg-purple-600 shadow-md group-hover:scale-125 transition-transform"></div>
        
        <div class="bg-white p-6 md:p-8 rounded-2xl shadow-sm hover:shadow-xl transition-all duration-300 border border-transparent hover:border-purple-100">
            <div class="flex flex-col md:flex-row md:items-start md:justify-between mb-4">
                <div>
                    <span class="inline-block px-3 py-1 rounded-full text-xs font-semibold bg-purple-100 text-purple-600 mb-2">
                        <?= esc($item['jenjang']) ?>
                    </span>
                    <h3 class="text-xl font-bold text-gray-900"><?= esc($item['nama_sekolah']) ?></h3>
                    <div class="text-gray-600 font-medium mt-1"><?= esc($item['jurusan']) ?></div>
                </div>
                <div class="mt-2 md:mt-0 text-right">
                    <div class="text-2xl font-bold text-purple-600"><?= esc($item['tahun_masuk']) ?> - <?= esc($item['tahun_lulus'] ?? 'Sekarang') ?></div>
                    <?php if(!empty($item['nilai_akhir'])): ?>
                        <div class="text-sm text-gray-500 mt-1">IPK/Nilai: <span class="font-semibold text-gray-700"><?= esc($item['nilai_akhir']) ?></span></div>
                    <?php endif; ?>
                </div>
            </div>
            
            <?php if(!empty($item['prestasi'])): ?>
            <div class="mt-4 p-4 bg-yellow-50 rounded-xl border border-yellow-100">
                <div class="flex items-start">
                    <i class="fa-solid fa-trophy text-yellow-500 mt-1 mr-3"></i>
                    <div>
                        <h4 class="text-sm font-semibold text-yellow-800 uppercase tracking-wide">Prestasi</h4>
                        <p class="text-gray-700 mt-1"><?= esc($item['prestasi']) ?></p>
                    </div>
                </div>
            </div>
            <?php endif; ?>
            
            <?php if(!empty($item['alamat_sekolah'])): ?>
            <div class="mt-4 flex items-center text-gray-400 text-sm">
                <i class="fa-solid fa-map-pin w-4 mr-2"></i>
                <?= esc($item['alamat_sekolah']) ?>
            </div>
            <?php endif; ?>
        </div>
    </div>
    <?php endforeach; ?>
    
    <?php if(empty($education)): ?>
        <div class="text-center py-12 text-gray-500">
            <p>Tidak ada riwayat pendidikan.</p>
        </div>
    <?php endif; ?>
</div>

<div class="mt-8 flex justify-center">
    <?= $pager->links() ?>
</div>

<?= $this->endSection() ?>
