<?= $this->extend('layout/admin') ?>

<?= $this->section('content') ?>
<div class="mb-6 flex flex-col md:flex-row justify-between items-center gap-4">
    <h1 class="text-2xl font-bold text-gray-800">Aktivitas Harian</h1>
    <a href="/admin/activity/create" class="px-4 py-2 bg-purple-600 text-white rounded-lg hover:bg-purple-700 transition-colors shadow-sm">
        <i class="fa-solid fa-plus mr-2"></i>Tambah Aktivitas
    </a>
</div>

<?php if (session()->getFlashdata('message')) : ?>
    <div class="p-4 mb-4 text-sm text-green-700 bg-green-100 rounded-lg" role="alert">
        <?= session()->getFlashdata('message') ?>
    </div>
<?php endif; ?>

<div class="bg-white rounded-xl shadow-sm border border-gray-100">
    <!-- Search & Filter -->
    <div class="p-5 border-b border-gray-100 flex flex-col md:flex-row justify-between items-center gap-4">
        <form action="" method="get" class="flex items-center w-full md:w-auto">
            <div class="relative w-full md:w-64">
                <input type="text" name="search" value="<?= esc($search) ?>" placeholder="Cari aktivitas..." class="w-full pl-10 pr-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-purple-500 text-sm">
                <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                    <i class="fa-solid fa-search text-gray-400"></i>
                </div>
            </div>
            <button type="submit" class="ml-2 px-4 py-2 bg-gray-100 text-gray-600 rounded-lg hover:bg-gray-200 transition-colors text-sm font-medium">Cari</button>
        </form>
        
        <div class="flex items-center space-x-2">
            <span class="text-sm text-gray-500">Urutkan:</span>
            <a href="?sort=tanggal&order=<?= $order == 'ASC' ? 'DESC' : 'ASC' ?>&search=<?= $search ?>" class="px-3 py-1 text-xs border rounded hover:bg-gray-50 <?= $sort == 'tanggal' ? 'bg-purple-50 text-purple-700 border-purple-200' : '' ?>">Tanggal</a>
            <a href="?sort=kategori&order=<?= $order == 'ASC' ? 'DESC' : 'ASC' ?>&search=<?= $search ?>" class="px-3 py-1 text-xs border rounded hover:bg-gray-50 <?= $sort == 'kategori' ? 'bg-purple-50 text-purple-700 border-purple-200' : '' ?>">Kategori</a>
        </div>
    </div>

    <!-- Table -->
    <div class="overflow-x-auto">
        <table class="w-full text-left border-collapse">
            <thead>
                <tr class="bg-gray-50 text-gray-600 text-sm uppercase tracking-wider">
                    <th class="p-4 border-b font-semibold">Tanggal & Waktu</th>
                    <th class="p-4 border-b font-semibold">Aktivitas</th>
                    <th class="p-4 border-b font-semibold">Kategori</th>
                    <th class="p-4 border-b font-semibold">Media</th>
                    <th class="p-4 border-b font-semibold text-center">Aksi</th>
                </tr>
            </thead>
            <tbody class="text-gray-700 text-sm">
                <?php foreach ($activities as $item) : ?>
                <tr class="hover:bg-purple-50 transition-colors border-b last:border-0 group">
                    <td class="p-4 whitespace-nowrap">
                        <div class="font-medium text-gray-900"><?= esc($item['tanggal']) ?></div>
                        <div class="text-xs text-gray-500"><?= esc($item['jam']) ?></div>
                    </td>
                    <td class="p-4">
                        <div class="font-medium text-gray-900"><?= esc($item['nama_aktivitas']) ?></div>
                        <div class="text-xs text-gray-500 truncate max-w-xs"><?= esc($item['deskripsi']) ?></div>
                    </td>
                    <td class="p-4">
                        <span class="px-2 py-1 text-xs font-semibold bg-gray-100 text-gray-600 rounded-full">
                            <?= esc($item['kategori'] ?? 'Tak Berkategori') ?>
                        </span>
                    </td>
                    <td class="p-4">
                        <?php if($item['foto']): ?>
                            <i class="fa-solid fa-image text-purple-600 mr-2" title="Ada Foto"></i>
                        <?php endif; ?>
                        <?php if($item['video']): ?>
                            <i class="fa-solid fa-video text-red-600" title="Ada Video"></i>
                        <?php endif; ?>
                    </td>
                    <td class="p-4 text-center">
                        <div class="flex items-center justify-center space-x-2 opacity-0 group-hover:opacity-100 transition-opacity">
                            <a href="/admin/activity/edit/<?= $item['id'] ?>" class="p-2 text-blue-600 hover:bg-blue-100 rounded transition-colors" title="Edit">
                                <i class="fa-solid fa-pen-to-square"></i>
                            </a>
                            <a href="/admin/activity/delete/<?= $item['id'] ?>" onclick="return confirm('Apakah Anda yakin?')" class="p-2 text-red-600 hover:bg-red-100 rounded transition-colors" title="Delete">
                                <i class="fa-solid fa-trash"></i>
                            </a>
                        </div>
                    </td>
                </tr>
                <?php endforeach; ?>
                <?php if(empty($activities)): ?>
                    <tr>
                        <td colspan="5" class="p-8 text-center text-gray-500">Tidak ada aktivitas ditemukan.</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <!-- Pagination -->
    <div class="p-5 border-t border-gray-100 flex justify-center">
        <?= $pager->links() ?>
    </div>
</div>
<?= $this->endSection() ?>
