<?php

namespace App\Models;

use CodeIgniter\Model;

class ActivityModel extends Model
{
    protected $table            = 'aktivitas_harian';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $returnType       = 'array';
    protected $allowedFields    = [
        'tanggal', 'jam', 'nama_aktivitas', 'deskripsi', 
        'foto', 'video', 'kategori'
    ];

    protected $useTimestamps = true;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    protected $validationRules      = [
        'tanggal' => 'required|valid_date',
        'jam' => 'required',
        'nama_aktivitas' => 'required|max_length[200]',
    ];
}
