<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\BiodataModel;

class Biodata extends BaseController
{
    protected $biodataModel;

    public function __construct()
    {
        $this->biodataModel = new BiodataModel();
    }

    public function index()
    {
        $search = $this->request->getGet('search');
        $sort = $this->request->getGet('sort') ?? 'id';
        $order = $this->request->getGet('order') ?? 'DESC';

        $model = $this->biodataModel;

        if ($search) {
            $model->groupStart()
                ->like('nama', $search)
                ->orLike('email', $search)
                ->orLike('keahlian', $search)
                ->groupEnd();
        }

        $data = [
            'title' => 'Biodata',
            'biodata' => $model->orderBy($sort, $order)->paginate(10),
            'pager' => $model->pager,
            'search' => $search,
            'sort' => $sort,
            'order' => $order
        ];
        return view('admin/biodata/index', $data);
    }

    public function create()
    {
        $data = ['title' => 'Tambah Biodata'];
        return view('admin/biodata/create', $data);
    }

    public function store()
    {
        if (!$this->validate([
            'nama' => 'required',
            'email' => 'required|valid_email',
            'foto' => 'permit_empty|is_image[foto]|mime_in[foto,image/jpg,image/jpeg,image/png,image/webp]|max_size[foto,2048]',
        ])) {
            return redirect()->to('/admin/biodata/create')->withInput()->with('errors', $this->validator->getErrors());
        }

        $foto = $this->request->getFile('foto');
        $fotoName = null;
        if ($foto && $foto->isValid() && !$foto->hasMoved()) {
            $fotoName = $foto->getRandomName();
            $foto->move(ROOTPATH . 'public/uploads/photos', $fotoName);
        }

        $this->biodataModel->save([
            'nama' => $this->request->getPost('nama'),
            'email' => $this->request->getPost('email'),
            'telepon' => $this->request->getPost('telepon'),
            'alamat' => $this->request->getPost('alamat'),
            'tempat_lahir' => $this->request->getPost('tempat_lahir'),
            'tanggal_lahir' => $this->request->getPost('tanggal_lahir'),
            'jenis_kelamin' => $this->request->getPost('jenis_kelamin'),
            'agama' => $this->request->getPost('agama'),
            'status_pernikahan' => $this->request->getPost('status_pernikahan'),
            'keahlian' => $this->request->getPost('keahlian'),
            'deskripsi' => $this->request->getPost('deskripsi'),
            'foto' => $fotoName,
        ]);

        return redirect()->to('/admin/biodata')->with('message', 'Biodata berhasil disimpan');
    }

    public function edit($id)
    {
        $data = [
            'title' => 'Edit Biodata',
            'biodata' => $this->biodataModel->find($id)
        ];
        return view('admin/biodata/edit', $data);
    }

    public function update($id)
    {
        if (!$this->validate([
            'foto' => 'permit_empty|is_image[foto]|mime_in[foto,image/jpg,image/jpeg,image/png,image/webp]|max_size[foto,2048]',
        ])) {
             return redirect()->to('/admin/biodata/edit/' . $id)->withInput()->with('errors', $this->validator->getErrors());
        }

        $biodata = $this->biodataModel->find($id);
        
        $foto = $this->request->getFile('foto');
        $fotoName = $biodata['foto'];
        if ($foto && $foto->isValid() && !$foto->hasMoved()) {
            $fotoName = $foto->getRandomName();
            $foto->move(ROOTPATH . 'public/uploads/photos', $fotoName);
        }

        $this->biodataModel->update($id, [
            'nama' => $this->request->getPost('nama'),
            'email' => $this->request->getPost('email'),
            'telepon' => $this->request->getPost('telepon'),
            'alamat' => $this->request->getPost('alamat'),
            'tempat_lahir' => $this->request->getPost('tempat_lahir'),
            'tanggal_lahir' => $this->request->getPost('tanggal_lahir'),
            'jenis_kelamin' => $this->request->getPost('jenis_kelamin'),
            'agama' => $this->request->getPost('agama'),
            'status_pernikahan' => $this->request->getPost('status_pernikahan'),
            'keahlian' => $this->request->getPost('keahlian'),
            'deskripsi' => $this->request->getPost('deskripsi'),
            'foto' => $fotoName,
        ]);

        return redirect()->to('/admin/biodata')->with('message', 'Biodata berhasil diperbarui');
    }

    public function delete($id)
    {
        $this->biodataModel->delete($id);
        return redirect()->to('/admin/biodata')->with('message', 'Biodata berhasil dihapus');
    }
}
