<?php

use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes
 */

$routes->get('/', 'Home::index');

// Public Routes
$routes->get('/biodata', 'Home::biodata');
$routes->get('/education', 'Home::education');
$routes->get('/activities', 'Home::activities');

// Auth Routes
$routes->get('login', 'Auth::login');
$routes->post('auth/attemptLogin', 'Auth::attemptLogin');
$routes->get('logout', 'Auth::logout');

// Admin Routes
$routes->group('admin', ['filter' => 'auth', 'namespace' => 'App\Controllers\Admin'], function($routes) {
    $routes->get('/', 'Dashboard::index');
    $routes->get('dashboard', 'Dashboard::index');

    // Biodata CRUD
    $routes->get('biodata', 'Biodata::index');
    $routes->get('biodata/create', 'Biodata::create');
    $routes->post('biodata/store', 'Biodata::store');
    $routes->get('biodata/edit/(:num)', 'Biodata::edit/$1');
    $routes->post('biodata/update/(:num)', 'Biodata::update/$1');
    $routes->get('biodata/delete/(:num)', 'Biodata::delete/$1');

    // Education CRUD
    $routes->get('education', 'Education::index');
    $routes->get('education/create', 'Education::create');
    $routes->post('education/store', 'Education::store');
    $routes->get('education/edit/(:num)', 'Education::edit/$1');
    $routes->post('education/update/(:num)', 'Education::update/$1');
    $routes->get('education/delete/(:num)', 'Education::delete/$1');

    // Activity CRUD
    $routes->get('activity', 'Activity::index');
    $routes->get('activity/create', 'Activity::create');
    $routes->post('activity/store', 'Activity::store');
    $routes->get('activity/edit/(:num)', 'Activity::edit/$1');
    $routes->post('activity/update/(:num)', 'Activity::update/$1');
    $routes->get('activity/delete/(:num)', 'Activity::delete/$1');
});
