<?= $this->extend('layouts/admin') ?>

<?= $this->section('header_actions') ?>
<a href="<?= base_url('admin/pendidikan/create') ?>" class="btn btn-primary">
    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
        <line x1="12" y1="5" x2="12" y2="19"></line>
        <line x1="5" y1="12" x2="19" y2="12"></line>
    </svg>
    Tambah Pendidikan
</a>
<?= $this->endSection() ?>

<?= $this->section('content') ?>
<!-- Filter Bar -->
<form action="<?= base_url('admin/pendidikan') ?>" method="get" class="filter-bar" style="margin-bottom: var(--space-6);">
    <div class="search-box">
        <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="search-icon">
            <circle cx="11" cy="11" r="8"></circle>
            <line x1="21" y1="21" x2="16.65" y2="16.65"></line>
        </svg>
        <input type="text" name="q" placeholder="Cari pendidikan..." class="search-input" value="<?= esc($search ?? '') ?>">
    </div>
    
    <select name="status" class="filter-select">
        <option value="">Semua Status</option>
        <option value="ongoing" <?= ($status ?? '') === 'ongoing' ? 'selected' : '' ?>>Ongoing</option>
        <option value="completed" <?= ($status ?? '') === 'completed' ? 'selected' : '' ?>>Completed</option>
    </select>
    
    <select name="sort" class="filter-select">
        <option value="latest" <?= ($sort ?? 'latest') === 'latest' ? 'selected' : '' ?>>Terbaru</option>
        <option value="oldest" <?= ($sort ?? '') === 'oldest' ? 'selected' : '' ?>>Terlama</option>
        <option value="title_asc" <?= ($sort ?? '') === 'title_asc' ? 'selected' : '' ?>>Institusi A-Z</option>
    </select>
    
    <button type="submit" class="btn btn-primary btn-sm">Filter</button>
    <?php if (!empty($search) || !empty($status)): ?>
    <a href="<?= base_url('admin/pendidikan') ?>" class="btn btn-secondary btn-sm">Reset</a>
    <?php endif; ?>
</form>

<!-- Table -->
<div class="admin-table-wrapper">
    <div class="admin-table-header">
        <p style="color: var(--color-text-muted); margin: 0;">Menampilkan <?= count($educations) ?> dari <?= $total ?> pendidikan</p>
    </div>
    
    <?php if (!empty($educations)): ?>
    <table class="admin-table">
        <thead>
            <tr>
                <th>Institusi</th>
                <th>Jenjang</th>
                <th>Status</th>
                <th>Tahun</th>
                <th style="width: 100px;">Aksi</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($educations as $edu): ?>
            <tr>
                <td>
                    <div style="font-weight: 500; color: var(--color-text-primary);"><?= esc($edu['institution']) ?></div>
                    <div style="font-size: 0.75rem; color: var(--color-text-muted);"><?= esc($edu['major']) ?></div>
                </td>
                <td><span class="tag"><?= esc($edu['degree']) ?></span></td>
                <td><span class="status-badge <?= $edu['status'] ?>"><?= ucfirst($edu['status']) ?></span></td>
                <td style="color: var(--color-text-muted);"><?= esc($edu['start_year']) ?> - <?= $edu['end_year'] ? esc($edu['end_year']) : 'Sekarang' ?></td>
                <td>
                    <div class="table-actions">
                        <a href="<?= base_url('admin/pendidikan/edit/' . $edu['id']) ?>" class="btn-icon" title="Edit">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                <path d="M11 4H4a2 2 0 0 0-2 2v14a2 2 0 0 0 2 2h14a2 2 0 0 0 2-2v-7"></path>
                                <path d="M18.5 2.5a2.121 2.121 0 0 1 3 3L12 15l-4 1 1-4 9.5-9.5z"></path>
                            </svg>
                        </a>
                        <form action="<?= base_url('admin/pendidikan/delete/' . $edu['id']) ?>" method="post" class="confirm-delete" style="display: inline;">
                            <?= csrf_field() ?>
                            <button type="submit" class="btn-icon danger" title="Hapus">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <polyline points="3 6 5 6 21 6"></polyline>
                                    <path d="M19 6v14a2 2 0 0 1-2 2H7a2 2 0 0 1-2-2V6m3 0V4a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v2"></path>
                                </svg>
                            </button>
                        </form>
                    </div>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    
    <div class="admin-table-footer">
        <div class="pagination">
            <?= $pager->links() ?>
        </div>
    </div>
    <?php else: ?>
    <div class="empty-state" style="padding: var(--space-12);">
        <svg xmlns="http://www.w3.org/2000/svg" width="48" height="48" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1" stroke-linecap="round" stroke-linejoin="round" style="color: var(--color-text-muted); margin-bottom: var(--space-4);">
            <path d="M22 10v6M2 10l10-5 10 5-10 5z"></path>
            <path d="M6 12v5c3 3 9 3 12 0v-5"></path>
        </svg>
        <h3 class="empty-state-title">Belum Ada Pendidikan</h3>
        <p class="empty-state-text">Mulai tambahkan pendidikan pertama Anda</p>
        <a href="<?= base_url('admin/pendidikan/create') ?>" class="btn btn-primary" style="margin-top: var(--space-4);">Tambah Pendidikan</a>
    </div>
    <?php endif; ?>
</div>
<?= $this->endSection() ?>
