<?php

namespace App\Controllers;

use App\Models\BiodataModel;

class AboutController extends BaseController
{
    protected $biodataModel;

    public function __construct()
    {
        $this->biodataModel = new BiodataModel();
    }

    public function index()
    {
        $biodata = $this->biodataModel->getBiodata();

        if (!$biodata) {
            throw new \CodeIgniter\Exceptions\PageNotFoundException('Biodata tidak ditemukan');
        }

        $data = [
            'title'   => 'Tentang Saya',
            'biodata' => $biodata,
        ];

        return view('pages/about', $data);
    }
}
