<?php

use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes
 */

// ============================================================================
// PUBLIC ROUTES
// ============================================================================
$routes->get('/', 'HomeController::index');
$routes->get('about', 'AboutController::index');
$routes->get('aktivitas', 'ActivityController::index');
$routes->get('aktivitas/(:segment)', 'ActivityController::show/$1');
$routes->get('pendidikan', 'EducationController::index');
$routes->get('notion', 'NotionController::index');

// Serve uploaded files
$routes->get('uploads/(:any)', function($filepath) {
    $path = WRITEPATH . 'uploads/' . $filepath;
    
    if (!file_exists($path)) {
        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
    }
    
    $mime = mime_content_type($path);
    $allowedMimes = ['image/jpeg', 'image/png', 'image/webp', 'image/gif'];
    
    if (!in_array($mime, $allowedMimes)) {
        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
    }
    
    return response()
        ->setHeader('Content-Type', $mime)
        ->setHeader('Cache-Control', 'public, max-age=86400')
        ->setBody(file_get_contents($path));
});

// ============================================================================
// ADMIN ROUTES (Auth required)
// ============================================================================

// Auth routes (no filter needed)
$routes->get('admin/login', 'Admin\AuthController::login');
$routes->post('admin/login', 'Admin\AuthController::attemptLogin');
$routes->post('admin/logout', 'Admin\AuthController::logout');

// Protected admin routes
$routes->group('admin', ['filter' => 'auth'], function($routes) {
    // Dashboard
    $routes->get('/', 'Admin\DashboardController::index');
    $routes->get('dashboard', 'Admin\DashboardController::index');
    
    // Biodata (single record, edit only)
    $routes->get('biodata', 'Admin\BiodataController::edit');
    $routes->post('biodata', 'Admin\BiodataController::update');
    
    // Activities CRUD
    $routes->get('aktivitas', 'Admin\ActivityController::index');
    $routes->get('aktivitas/create', 'Admin\ActivityController::create');
    $routes->post('aktivitas/store', 'Admin\ActivityController::store');
    $routes->get('aktivitas/edit/(:num)', 'Admin\ActivityController::edit/$1');
    $routes->post('aktivitas/update/(:num)', 'Admin\ActivityController::update/$1');
    $routes->post('aktivitas/delete/(:num)', 'Admin\ActivityController::delete/$1');
    
    // Educations CRUD
    $routes->get('pendidikan', 'Admin\EducationController::index');
    $routes->get('pendidikan/create', 'Admin\EducationController::create');
    $routes->post('pendidikan/store', 'Admin\EducationController::store');
    $routes->get('pendidikan/edit/(:num)', 'Admin\EducationController::edit/$1');
    $routes->post('pendidikan/update/(:num)', 'Admin\EducationController::update/$1');
    $routes->post('pendidikan/delete/(:num)', 'Admin\EducationController::delete/$1');
});
