# Portfolio CI4

Aplikasi Portfolio modern dengan CodeIgniter 4, featuring 3D hero animation menggunakan Three.js.

## Features

### Public Pages
- **Home**: Hero section dengan 3D Glass Orb animation, ringkasan biodata, dan aktivitas terbaru
- **About**: Halaman biodata lengkap dengan skills dan social links
- **Aktivitas**: List aktivitas dengan search, filter kategori, dan pagination
- **Pendidikan**: Riwayat pendidikan dengan search, filter jenjang, dan pagination
- **Notion**: Optional embed halaman Notion publik

### Admin Panel
- **Login**: Secure authentication dengan rate limiting (5x gagal = 5 menit lockout)
- **Dashboard**: Statistik dan overview
- **CRUD Biodata**: Edit single record biodata
- **CRUD Aktivitas**: Create, read, update, delete dengan search/filter/pagination
- **CRUD Pendidikan**: Create, read, update, delete dengan search/filter/pagination

### Security Features
- CSRF Protection aktif
- Password hashing dengan bcrypt
- Session regeneration setelah login
- Rate limiting untuk login
- Auth filter untuk protected routes
- Input validation dan output escaping
- Safe file upload dengan whitelist MIME types

## Tech Stack

- **Framework**: CodeIgniter 4.6+
- **PHP**: 8.1+
- **Database**: MySQL 5.7+ / MariaDB 10.3+
- **Frontend**: Vanilla CSS dengan design tokens, Bootstrap 5 compatible
- **3D Animation**: Three.js r128

---

## Installation

### 1. Clone atau Copy Project

```bash
# Pastikan folder kosong
cd c:\xampp\htdocs\regif
```

### 2. Install Dependencies

```bash
composer install
```

### 3. Setup Environment

Copy file `env` menjadi `.env` dan sesuaikan konfigurasi:

```bash
copy env .env
```

Edit `.env`:

```ini
CI_ENVIRONMENT = development

app.baseURL = 'http://localhost:8080/'

database.default.hostname = localhost
database.default.database = db_portfolio
database.default.username = root
database.default.password = 
database.default.DBDriver = MySQLi
```

### 4. Buat Database

Buat database di MySQL:

```sql
CREATE DATABASE db_portfolio CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci;
```

### 5. Jalankan Migrations

```bash
php spark migrate
```

### 6. Jalankan Seeders

```bash
php spark db:seed DatabaseSeeder
```

Atau jalankan satu per satu:

```bash
php spark db:seed UserSeeder
php spark db:seed BiodataSeeder
php spark db:seed ActivitySeeder
php spark db:seed EducationSeeder
```

### 7. Buat Folder Upload

```bash
mkdir writable\uploads\photos
mkdir writable\uploads\covers
```

### 8. Jalankan Development Server

```bash
php spark serve
```

Buka browser: **http://localhost:8080**

---

## Default Admin Credentials

| Email | Password |
|-------|----------|
| admin@portfolio.dev | password123 |

**Admin URL**: http://localhost:8080/admin/login

---

## Notion Integration (Optional)

### Mode A: Embed (Simpel)

1. Edit file `.env`
2. Tambahkan URL halaman Notion publik:

```ini
NOTION_PUBLIC_URL = 'https://your-notion-page.notion.site/your-public-page'
```

3. Akses halaman `/notion` di website

### Mode B: API (Advanced)

Fitur ini opsional. Jika ingin mengaktifkan:

1. Buat Notion Integration di [developers.notion.com](https://developers.notion.com)
2. Dapatkan token dan database ID
3. Edit `.env`:

```ini
NOTION_TOKEN = 'secret_xxx'
NOTION_DATABASE_ID = 'xxx'
```

Jika env kosong, fitur Notion akan disabled tanpa error.

---

## Folder Structure

```
regif/
├── app/
│   ├── Config/
│   │   ├── Filters.php      # Auth filter registration
│   │   └── Routes.php       # All routes configuration
│   ├── Controllers/
│   │   ├── HomeController.php
│   │   ├── AboutController.php
│   │   ├── ActivityController.php
│   │   ├── EducationController.php
│   │   ├── NotionController.php
│   │   └── Admin/
│   │       ├── AuthController.php
│   │       ├── DashboardController.php
│   │       ├── BiodataController.php
│   │       ├── ActivityController.php
│   │       └── EducationController.php
│   ├── Database/
│   │   ├── Migrations/      # Database schema
│   │   └── Seeds/           # Sample data
│   ├── Filters/
│   │   └── AuthFilter.php   # Admin route protection
│   ├── Libraries/
│   │   └── LoginAttempt.php # Rate limiting
│   ├── Models/
│   │   ├── UserModel.php
│   │   ├── BiodataModel.php
│   │   ├── ActivityModel.php
│   │   └── EducationModel.php
│   └── Views/
│       ├── layouts/         # Public & admin layouts
│       ├── pages/           # Public pages
│       ├── activities/      # Activity views
│       ├── educations/      # Education views
│       └── admin/           # Admin panel views
├── public/
│   └── assets/
│       ├── css/
│       │   ├── app.css      # Main styles + design tokens
│       │   └── admin.css    # Admin-specific styles
│       └── js/
│           └── three/
│               └── heroScene.js  # 3D hero animation
├── writable/
│   └── uploads/             # Uploaded files
├── .env                     # Environment config
└── README.md
```

---

## Search & Filter Query Params

### Public Aktivitas
```
/aktivitas?q=laravel&category=Project&page=2
```

### Public Pendidikan
```
/pendidikan?q=universitas&degree=S1&page=1
```

### Admin Aktivitas
```
/admin/aktivitas?q=test&status=published&category=Project&sort=latest&page=1
```

### Admin Pendidikan
```
/admin/pendidikan?q=test&status=ongoing&sort=latest&page=1
```

---

## 3D Hero Animation

Hero section menggunakan Three.js dengan efek **Glass Orb + Liquid Light**:

- Bola kaca dengan efek refraction
- Floating particles mengorbit
- Mouse parallax untuk interaksi
- Auto-disable untuk `prefers-reduced-motion`
- Fallback gradient untuk mobile/low-performance devices

File: `public/assets/js/three/heroScene.js`

---

## Design Tokens

CSS design tokens di `app.css`:

```css
--color-primary: #2563EB;       /* Blue */
--color-accent: #14B8A6;        /* Teal */
--color-bg-primary: #FFFFFF;    /* White */
--color-bg-secondary: #F8FAFC;  /* Light gray */
```

Font: **Inter** (Google Fonts)

---

## License

MIT License
