<?= $this->extend('layout/admin_template'); ?>

<?= $this->section('content'); ?>
<div class="row justify-content-center">
    <div class="col-md-6">
        <div class="card border-0 shadow-sm rounded-4">
            <div class="card-header bg-white border-0 pt-4 px-4 pb-0">
                <h5 class="card-title fw-bold text-primary mb-0"><i class="bi bi-shield-lock-fill me-2"></i>Ganti Password</h5>
            </div>
            <div class="card-body p-4">
                
                <?php if(session()->getFlashdata('error')): ?>
                    <div class="alert alert-danger rounded-3" role="alert">
                        <?= session()->getFlashdata('error') ?>
                    </div>
                <?php endif; ?>

                <?php if(session()->getFlashdata('success')): ?>
                    <div class="alert alert-success rounded-3" role="alert">
                        <?= session()->getFlashdata('success') ?>
                    </div>
                <?php endif; ?>

                <form action="<?= base_url('/admin/profile/update-password'); ?>" method="post">
                    <?= csrf_field(); ?>
                    
                    <div class="mb-3">
                        <label for="current_password" class="form-label text-muted small fw-bold text-uppercase">Password Saat Ini</label>
                        <input type="password" class="form-control bg-light border-0 py-2 <?= (validation_show_error('current_password')) ? 'is-invalid' : ''; ?>" id="current_password" name="current_password">
                        <div class="invalid-feedback"><?= validation_show_error('current_password'); ?></div>
                    </div>

                    <div class="mb-3">
                        <label for="new_password" class="form-label text-muted small fw-bold text-uppercase">Password Baru</label>
                        <input type="password" class="form-control bg-light border-0 py-2 <?= (validation_show_error('new_password')) ? 'is-invalid' : ''; ?>" id="new_password" name="new_password">
                        <div class="invalid-feedback"><?= validation_show_error('new_password'); ?></div>
                    </div>

                    <div class="mb-4">
                        <label for="confirm_password" class="form-label text-muted small fw-bold text-uppercase">Konfirmasi Password Baru</label>
                        <input type="password" class="form-control bg-light border-0 py-2 <?= (validation_show_error('confirm_password')) ? 'is-invalid' : ''; ?>" id="confirm_password" name="confirm_password">
                        <div class="invalid-feedback"><?= validation_show_error('confirm_password'); ?></div>
                    </div>

                    <div class="d-grid">
                        <button type="submit" class="btn btn-primary rounded-pill py-2 fw-bold text-white shadow-sm glow-effect">
                            <i class="bi bi-check-circle-fill me-2"></i>Simpan Password
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<?= $this->endSection(); ?>
