# Slide Presentasi: Penambahan Field Tanggal Lahir

---

## **PENAMBAHAN FIELD TANGGAL LAHIR PADA SISTEM PENDATAAN PEGAWAI**

### **Update Tugas: Kolom C. tanggal_lahir = date**

---

### **1. Deskripsi Perubahan**

**Field Baru yang Ditambahkan:**
- **Nama Field:** `tanggal_lahir`
- **Tipe Data:** `DATE`
- **Posisi:** Setelah kolom `nama_pegawai`
- **Karakteristik:** 
  - Optional (nullable)
  - Format: YYYY-MM-DD
  - Menyimpan tanggal lahir pegawai

---

### **2. File-File yang Dimodifikasi**

#### **A. Database Migration**
📁 **Lokasi:** `app/Database/Migrations/2025-01-27-100000_AddTanggalLahirToPegawai.php`

**Fungsi:**
- Menambahkan kolom `tanggal_lahir` ke tabel `pegawai`
- Menggunakan tipe data `DATE`
- Dapat di-rollback jika diperlukan

**Script:**
```php
public function up()
{
    $fields = [
        'tanggal_lahir' => [
            'type'       => 'DATE',
            'null'       => true,
            'after'      => 'nama_pegawai'
        ]
    ];
    $this->forge->addColumn('pegawai', $fields);
}
```

---

#### **B. Model (PegawaiModel)**
📁 **Lokasi:** `app/Models/PegawaiModel.php`

**Perubahan:**
- Menambahkan `tanggal_lahir` ke dalam `$allowedFields`

**Script:**
```php
protected $allowedFields = [
    'nama_pegawai', 
    'tanggal_lahir',  // ← Field baru
    'jenis_kelamin', 
    'foto_pegawai', 
    'divisi'
];
```

**Penjelasan:**
- `allowedFields` menentukan field mana saja yang boleh diisi melalui model
- Tanpa ini, field `tanggal_lahir` tidak akan tersimpan ke database

---

#### **C. Controller (PegawaiAdmin)**
📁 **Lokasi:** `app/Controllers/PegawaiAdmin.php`

**Perubahan pada 3 bagian:**

**1. Validasi (Method `create()` dan `edit()`):**
```php
$validation->setRules([
    'nama_pegawai' => 'required|min_length[3]',
    'tanggal_lahir' => 'permit_empty|valid_date',  // ← Validasi baru
    'jenis_kelamin' => 'required|in_list[laki-laki,perempuan]',
    'divisi' => 'required'
]);
```

**2. Insert Data (Method `create()`):**
```php
$this->pegawaiModel->insert([
    'nama_pegawai' => $this->request->getPost('nama_pegawai'),
    'tanggal_lahir' => $this->request->getPost('tanggal_lahir') ?: null,  // ← Field baru
    'jenis_kelamin' => $this->request->getPost('jenis_kelamin'),
    'foto_pegawai' => $fotoName,
    'divisi' => $this->request->getPost('divisi')
]);
```

**3. Update Data (Method `edit()`):**
```php
$this->pegawaiModel->update($id, [
    'nama_pegawai' => $this->request->getPost('nama_pegawai'),
    'tanggal_lahir' => $this->request->getPost('tanggal_lahir') ?: null,  // ← Field baru
    'jenis_kelamin' => $this->request->getPost('jenis_kelamin'),
    'foto_pegawai' => $fotoName,
    'divisi' => $this->request->getPost('divisi')
]);
```

**Penjelasan:**
- `permit_empty`: Field boleh kosong
- `valid_date`: Memastikan format tanggal valid
- `?: null`: Jika kosong, set ke `null`

---

#### **D. View - Form Create**
📁 **Lokasi:** `app/Views/admin/pegawai/create.php`

**Script:**
```php
<div class="form-group">
    <label for="tanggal_lahir">Tanggal Lahir</label>
    <input type="date" 
           name="tanggal_lahir" 
           id="tanggal_lahir" 
           class="form-control" 
           value="<?= old('tanggal_lahir') ?>">
    <small class="form-text text-muted">Format: YYYY-MM-DD</small>
</div>
```

**Penjelasan:**
- `type="date"`: HTML5 date picker
- `old('tanggal_lahir')`: Mempertahankan nilai jika validasi gagal

---

#### **E. View - Form Edit**
📁 **Lokasi:** `app/Views/admin/pegawai/edit.php`

**Script:**
```php
<div class="form-group">
    <label for="tanggal_lahir">Tanggal Lahir</label>
    <input type="date" 
           name="tanggal_lahir" 
           id="tanggal_lahir" 
           class="form-control" 
           value="<?= old('tanggal_lahir', $pegawai['tanggal_lahir'] ?? '') ?>">
    <small class="form-text text-muted">Format: YYYY-MM-DD</small>
</div>
```

**Penjelasan:**
- `old('tanggal_lahir', $pegawai['tanggal_lahir'] ?? '')`: 
  - Prioritas 1: Nilai dari old (jika validasi gagal)
  - Prioritas 2: Nilai dari database
  - Prioritas 3: String kosong

---

#### **F. View - Admin List (Index)**
📁 **Lokasi:** `app/Views/admin/pegawai/index.php`

**1. Header Tabel:**
```php
<th>Tanggal Lahir</th>  // ← Kolom baru
```

**2. Data Tabel:**
```php
<td><?= $p['tanggal_lahir'] ? date('d-m-Y', strtotime($p['tanggal_lahir'])) : '-' ?></td>
```

**Penjelasan:**
- `date('d-m-Y', ...)`: Format tampilan: 27-01-2025
- `strtotime()`: Konversi string ke timestamp
- Jika kosong, tampilkan `-`

---

#### **G. View - Public (Frontend)**
📁 **Lokasi:** `app/Views/pegawai/index.php`

**Script:**
```php
<div class="pegawai-meta">
    <?php if ($p['tanggal_lahir']): ?>
        <div><strong>Tanggal Lahir:</strong> <?= date('d-m-Y', strtotime($p['tanggal_lahir'])) ?></div>
    <?php endif; ?>
    <div><strong>Jenis Kelamin:</strong> <?= esc($p['jenis_kelamin']) ?></div>
    <div><strong>Divisi:</strong> <?= esc($p['divisi'] ?? '-') ?></div>
</div>
```

**Penjelasan:**
- Hanya tampil jika `tanggal_lahir` tidak kosong
- Format: dd-mm-yyyy (contoh: 27-01-2025)

---

### **3. Cara Menjalankan Migration**

**Jalankan di terminal:**
```bash
php spark migrate
```

**Atau untuk rollback:**
```bash
php spark migrate:rollback
```

---

### **4. Alur Kerja (Workflow)**

```
1. User mengisi form create/edit
   ↓
2. Input tanggal_lahir dikirim ke controller
   ↓
3. Controller validasi format tanggal
   ↓
4. Data disimpan ke database (jika valid)
   ↓
5. View menampilkan tanggal dalam format d-m-Y
```

---

### **5. Fitur yang Didukung**

✅ **Create:** Input tanggal lahir saat tambah pegawai  
✅ **Read:** Tampilkan tanggal lahir di halaman admin & public  
✅ **Update:** Edit tanggal lahir pegawai  
✅ **Delete:** Tidak perlu perubahan (otomatis terhapus)  

---

### **6. Format Data**

**Database:** `YYYY-MM-DD` (contoh: 2025-01-27)  
**Tampilan:** `DD-MM-YYYY` (contoh: 27-01-2025)  

---

### **7. Keamanan**

- ✅ Validasi format tanggal
- ✅ Sanitasi input (CodeIgniter otomatis)
- ✅ Field optional (tidak wajib diisi)

---

### **Kesimpulan**

Penambahan field `tanggal_lahir` telah diimplementasikan pada:
- ✅ Database (migration)
- ✅ Model (allowedFields)
- ✅ Controller (validasi & CRUD)
- ✅ View Admin (create, edit, index)
- ✅ View Public (index)

**Total file yang dimodifikasi: 7 file**

---

**Terima Kasih**

