## Slide 1 – Portal Berita Produksi Login
- File: `app/Views/auth/login.php`
- Komponen utama: kartu kaca, logo UYM, form username/password, tombol sosial
- Background: `public/images/login-mountain.jpg`
- Fokus desain: align center, tone profesional, responsive

## Slide 2 – Struktur & Styling
- Layout flex dua kolom (`.glass-card`, `.brand-section`, `.form-section`)
- Form control dengan ikon, toggle password, tombol `Log In`
- Responsif lewat media query max-width 768px
- Kode CSS & HTML berada di `app/Views/auth/login.php`

## Slide 3 – Proses Login Konvensional
- Controller: `app/Controllers/Auth.php`
- Fungsi `processLogin()` validasi username/password dan session admin-only
- Fitur Remember Me (cookie `remember_token`)
- Redirect otomatis ke `/admin/news` setelah sukses

## Slide 4 – Social Login (Google & Facebook)
- Konfigurasi kredensial: `app/Config/SocialAuth.php`
- Routes: `Auth::redirectToGoogle/Facebook` dan callback
- Menyimpan provider, provider_id, avatar di tabel `users`
- Migration kolom sosial: `app/Database/Migrations/2025-11-24-135800_AddSocialColumnsToUsers.php`

## Slide 5 – Keamanan & Filter
- Filter `app/Filters/AuthFilter.php` melindungi grup route `admin/*`
- Password hashed `password_hash()` di `UserModel`
- Session destroy + cookie cleanup pada logout
- CSRF helper tersedia di form (`<?= csrf_field() ?>`)

## Slide 6 – Assets & Setup
- Background: `public/images/login-mountain.jpg` (dapat diganti)
- Logo: `public/images/logo-uym.png` dengan fallback `logo-uym.svg`
- Panduan setup: `SETUP_LOGIN.md` (migrasi, seeder, konfigurasi social)
- Demo credentials button mengisi `admin/admin123`








