<?php
$currentUri = uri_string();
$request = service('request');
$segments = $request->getUri()->getSegments();
// Deteksi halaman aktif
$isHome = (empty($segments) || $currentUri == '' || $currentUri == '/');
$isNews = ($currentUri == 'news' || (isset($segments[0]) && $segments[0] == 'news'));
$isPegawai = ($currentUri == 'pegawai' || (isset($segments[0]) && $segments[0] == 'pegawai'));
$isAbout = ($currentUri == 'about' || (isset($segments[0]) && $segments[0] == 'about'));
$isContact = ($currentUri == 'contact' || (isset($segments[0]) && $segments[0] == 'contact'));
$isFaqs = ($currentUri == 'faqs' || (isset($segments[0]) && $segments[0] == 'faqs'));
?>
<nav class="navbar navbar-expand-lg navbar-light bg-white main-navbar shadow-sm">
    <div class="container">
        <a class="navbar-brand mb-0 h5 main-navbar-brand <?= $isHome ? 'active' : '' ?>" href="<?= base_url() ?>">
            Portal Berita
        </a>
        <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="navbarNav">
            <ul class="navbar-nav ml-auto main-navbar-links">
                <li class="nav-item">
                    <a class="nav-link <?= $isNews ? 'active' : '' ?>" href="<?= base_url('news') ?>">News</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?= $isPegawai ? 'active' : '' ?>" href="<?= base_url('pegawai') ?>">Pegawai</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?= $isAbout ? 'active' : '' ?>" href="<?= base_url('about') ?>">About</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?= $isContact ? 'active' : '' ?>" href="<?= base_url('contact') ?>">Contact</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?= $isFaqs ? 'active' : '' ?>" href="<?= base_url('faqs') ?>">Faqs</a>
                </li>
            </ul>
        </div>
    </div>
</nav>
<style>
body {
    background-color: #f4f0eb;
}

.main-navbar {
    border-bottom: 1px solid #e3ded6;
    position: relative;
    z-index: 1000;
}

.main-navbar .container {
    display: flex;
    justify-content: space-between;
    align-items: center;
    flex-wrap: wrap;
}

.main-navbar-brand {
    letter-spacing: 0.15em;
    text-transform: uppercase;
    font-size: 0.9rem;
    color: #333;
    font-weight: 600;
    text-decoration: none;
}

.main-navbar-brand.active {
    color: #007c82;
}

/* Hamburger Button Styling */
.navbar-toggler {
    border: 1px solid rgba(0, 0, 0, 0.1);
    padding: 0.25rem 0.5rem;
    background-color: transparent;
    cursor: pointer;
    z-index: 1001;
    position: relative;
}

.navbar-toggler:focus {
    outline: 2px solid #007c82;
    outline-offset: 2px;
}

.navbar-toggler-icon {
    display: inline-block;
    width: 1.5em;
    height: 1.5em;
    vertical-align: middle;
    background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' width='30' height='30' viewBox='0 0 30 30'%3e%3cpath stroke='rgba(0, 0, 0, 0.5)' stroke-linecap='round' stroke-miterlimit='10' stroke-width='2' d='M4 7h22M4 15h22M4 23h22'/%3e%3c/svg%3e");
    background-repeat: no-repeat;
    background-position: center;
    background-size: 100%;
}

.main-navbar-links {
    margin-top: 1rem;
}

.main-navbar-links .nav-link {
    font-size: 0.9rem;
    text-transform: uppercase;
    letter-spacing: 0.08em;
    color: #555;
    font-weight: 600;
    padding-left: 1rem;
    padding-right: 1rem;
    position: relative;
    display: block;
    padding-top: 0.5rem;
    padding-bottom: 0.5rem;
}

.main-navbar-links .nav-link.active,
.main-navbar-links .nav-link:hover {
    color: #007c82 !important;
}

.main-navbar-links .nav-link.active::after {
    content: "";
    position: absolute;
    left: 0.9rem;
    right: 0.9rem;
    bottom: 0.2rem;
    height: 2px;
    background-color: #007c82;
}

.btn-primary {
    background-color: #007c82;
    border-color: #007c82;
}

.btn-primary:hover,
.btn-primary:focus {
    background-color: #005f62;
    border-color: #005f62;
}

/* Mobile Responsive */
@media (max-width: 991.98px) {
    .main-navbar .container {
        padding-left: 15px;
        padding-right: 15px;
    }
    
    .navbar-collapse {
        width: 100%;
        margin-top: 1rem;
        border-top: 1px solid #e3ded6;
        padding-top: 1rem;
    }
    
    .main-navbar-links {
        margin-top: 0;
    }
    
    .main-navbar-links .nav-link {
        padding-left: 0;
        padding-right: 0;
        text-align: left;
    }
    
    .main-navbar-links .nav-link.active::after {
        left: 0;
        right: 0;
    }
    
    .navbar-toggler {
        display: block !important;
    }
}

@media (min-width: 992px) {
    .navbar-collapse {
        display: flex !important;
    }
    
    .main-navbar-links {
        margin-top: 0;
    }
}
</style>