<?php
$currentUri = uri_string();
$request = service('request');
$segments = $request->getUri()->getSegments();
// Deteksi halaman aktif berdasarkan segment
$isAdminHome = (empty($segments) || (count($segments) == 1 && $segments[0] == 'admin') || $currentUri == 'admin');
$isNews = (isset($segments[0]) && $segments[0] == 'admin' && isset($segments[1]) && $segments[1] == 'news');
$isPegawai = (isset($segments[0]) && $segments[0] == 'admin' && isset($segments[1]) && $segments[1] == 'pegawai');
?>
<nav class="navbar navbar-expand-lg navbar-light bg-white main-navbar shadow-sm">
    <div class="container d-flex justify-content-between align-items-center">
        <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse justify-content-between" id="navbarNav">
            <ul class="navbar-nav main-navbar-links">
                <li class="nav-item">
                    <a class="nav-link <?= $isAdminHome ? 'active' : '' ?>" href="<?= base_url('admin') ?>">Admin Panel</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?= $isNews ? 'active' : '' ?>" href="<?= base_url('admin/news') ?>">Berita</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?= $isPegawai ? 'active' : '' ?>" href="<?= base_url('admin/pegawai') ?>">Pegawai</a>
                </li>
            </ul>
            <ul class="navbar-nav align-items-center">
                <li class="nav-item">
                    <a href="<?= base_url('admin/news/new') ?>" class="btn btn-primary mr-3" style="border-radius:999px; background-color:#005f62; border-color:#005f62;">New Post</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="<?= base_url('admin/setting') ?>">Setting</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="<?= base_url('auth/logout') ?>">Keluar</a>
                </li>
            </ul>
        </div>
    </div>
</nav>
<style>
.main-navbar {
    border-bottom: 1px solid #e3ded6;
}

.main-navbar-links .nav-link {
    font-size: 0.9rem;
    text-transform: uppercase;
    letter-spacing: 0.08em;
    color: #555;
    font-weight: 600;
    padding-left: 1rem;
    padding-right: 1rem;
}

.main-navbar-links .nav-link.active {
    color: #333;
    font-weight: 600;
}
</style>