<?= $this->extend('layout/page_clean_layout') ?>

<?= $this->section('content') ?>

<section class="py-5 faqs-hero">
    <div class="container">
        <div class="text-center">
            <h1 class="display-5 font-weight-bold mb-3 faqs-main-title">Frequently Asked Questions</h1>
            <p class="lead faqs-subtitle">
                Temukan jawaban untuk pertanyaan umum tentang layanan dan divisi kami
            </p>
        </div>
    </div>
</section>

<section class="py-5 faqs-content">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-10">
                <div class="faqs-list">
                    <?php 
                    $categoryIcons = [
                        'Produksi' => 'fa-video',
                        'Marketing' => 'fa-bullhorn',
                        'IT' => 'fa-laptop-code',
                        'HR' => 'fa-users'
                    ];
                    $categoryColors = [
                        'Produksi' => '#6b3c3c',
                        'Marketing' => '#005f62',
                        'IT' => '#6b3c3c',
                        'HR' => '#005f62'
                    ];
                    foreach ($data_faqs as $index => $faq) : 
                        $category = $faq['category'];
                        $icon = $categoryIcons[$category] ?? 'fa-question';
                        $color = $categoryColors[$category] ?? '#6b3c3c';
                    ?>
                    <div class="faq-item-simple">
                        <div class="faq-header-simple" data-toggle="collapse" data-target="#faq<?= $index ?>" aria-expanded="false" aria-controls="faq<?= $index ?>">
                            <div class="faq-left">
                                <div class="faq-icon-small" style="background-color: <?= $color ?>;">
                                    <i class="fas <?= $icon ?>"></i>
                                </div>
                                <div class="faq-text">
                                    <span class="faq-category" style="color: <?= $color ?>;"><?= esc($category) ?></span>
                                    <h3 class="faq-question-simple"><?= esc($faq['question']) ?></h3>
                                </div>
                            </div>
                            <div class="faq-arrow">
                                <i class="fas fa-chevron-down"></i>
                            </div>
                        </div>
                        <div id="faq<?= $index ?>" class="collapse faq-answer-wrapper-simple">
                            <div class="faq-answer-simple">
                                <p><?= esc($faq['answer']) ?></p>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
    </div>
</section>

<style>
.faqs-hero {
    background: linear-gradient(135deg, #f4f0eb 0%, #e8e0d5 100%);
    padding: 4rem 0;
}

.faqs-main-title {
    color: #6b3c3c;
    letter-spacing: 0.1em;
}

.faqs-subtitle {
    max-width: 40rem;
    margin: 0 auto;
    color: #555;
    line-height: 1.8;
}

.faqs-content {
    background-color: #faf8f5;
    padding: 4rem 0;
}

.faqs-list {
    max-width: 900px;
    margin: 0 auto;
}

.faq-item-simple {
    background: white;
    border-radius: 12px;
    margin-bottom: 1.5rem;
    border: 2px solid #f4f0eb;
    overflow: hidden;
    transition: all 0.3s ease;
    box-shadow: 0 4px 15px rgba(0, 0, 0, 0.05);
}

.faq-item-simple:hover {
    box-shadow: 0 8px 25px rgba(107, 60, 60, 0.1);
    border-color: #e8e0d5;
}

.faq-header-simple {
    padding: 1.75rem 2rem;
    cursor: pointer;
    display: flex;
    align-items: center;
    justify-content: space-between;
    transition: all 0.3s ease;
    background: white;
}

.faq-header-simple:hover {
    background: #faf8f5;
}

.faq-header-simple[aria-expanded="true"] {
    background: #faf8f5;
    border-bottom: 2px solid #f4f0eb;
}

.faq-header-simple[aria-expanded="true"] .faq-arrow {
    transform: rotate(180deg);
    color: #6b3c3c;
}

.faq-header-simple[aria-expanded="true"] .faq-question-simple {
    color: #6b3c3c;
}

.faq-left {
    display: flex;
    align-items: center;
    gap: 1.25rem;
    flex: 1;
}

.faq-icon-small {
    width: 50px;
    height: 50px;
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    flex-shrink: 0;
    box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
}

.faq-icon-small i {
    font-size: 1.25rem;
    color: white;
}

.faq-text {
    flex: 1;
}

.faq-category {
    display: block;
    font-size: 0.75rem;
    font-weight: 700;
    text-transform: uppercase;
    letter-spacing: 0.1em;
    margin-bottom: 0.5rem;
}

.faq-question-simple {
    font-size: 1.15rem;
    font-weight: 600;
    color: #333;
    margin: 0;
    line-height: 1.5;
    transition: color 0.3s ease;
}

.faq-arrow {
    color: #999;
    font-size: 1rem;
    transition: all 0.3s ease;
    flex-shrink: 0;
    margin-left: 1rem;
}

.faq-answer-wrapper-simple {
    border-top: 2px solid #f4f0eb;
}

.faq-answer-simple {
    padding: 1.5rem 2rem 2rem;
    background: #faf8f5;
    padding-left: calc(2rem + 50px + 1.25rem);
}

.faq-answer-simple p {
    color: #555;
    font-size: 1rem;
    line-height: 1.8;
    margin: 0;
}

/* Responsive */
@media (max-width: 768px) {
    .faqs-main-title {
        font-size: 2rem;
    }

    .faq-header-simple {
        padding: 1.5rem 1.25rem;
        flex-wrap: wrap;
    }

    .faq-left {
        width: 100%;
        margin-bottom: 1rem;
    }

    .faq-arrow {
        position: absolute;
        top: 1.5rem;
        right: 1.25rem;
    }

    .faq-item-simple {
        position: relative;
    }

    .faq-answer-simple {
        padding: 1.25rem 1.25rem 1.75rem;
        padding-left: 1.25rem;
    }

    .faq-icon-small {
        width: 45px;
        height: 45px;
    }

    .faq-icon-small i {
        font-size: 1.1rem;
    }

    .faq-question-simple {
        font-size: 1.05rem;
    }
}
</style>

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">

<script>
document.addEventListener('DOMContentLoaded', function() {
    const faqHeaders = document.querySelectorAll('.faq-header-simple');
    
    faqHeaders.forEach(header => {
        header.addEventListener('click', function() {
            const targetId = this.getAttribute('data-target');
            const target = document.querySelector(targetId);
            const isExpanded = this.getAttribute('aria-expanded') === 'true';
            
            // Close all other FAQs
            faqHeaders.forEach(otherHeader => {
                if (otherHeader !== this) {
                    const otherTargetId = otherHeader.getAttribute('data-target');
                    const otherTarget = document.querySelector(otherTargetId);
                    if (otherTarget && otherTarget.classList.contains('show')) {
                        otherHeader.setAttribute('aria-expanded', 'false');
                        otherTarget.classList.remove('show');
                    }
                }
            });
        });
    });
});
</script>

<?= $this->endSection() ?>
