<?= $this->extend('layout/page_clean_layout') ?>

<?= $this->section('content') ?>

<section class="py-5 contact-section">
    <div class="container">
        <div class="contact-card-wrapper">
            <div class="row no-gutters">
                <!-- Contact Form -->
                <div class="col-lg-7 contact-form-section">
                    <div class="contact-form-inner">
                        <h1 class="contact-title">Hubungi Kami</h1>
                        <p class="contact-intro">
                            Punya ide event, ingin kerja sama produksi, atau butuh talent untuk project Anda? Kirim pesan ke tim Madani Yatsi Creative Industry melalui form berikut.
                        </p>

                        <form action="" class="contact-form">
                            <div class="form-group">
                                <label for="nama" class="form-label">NAMA</label>
                                <input type="text" 
                                       id="nama" 
                                       name="nama" 
                                       class="form-control" 
                                       placeholder="Nama lengkap" 
                                       required>
                            </div>

                            <div class="form-group">
                                <label for="email" class="form-label">EMAIL</label>
                                <input type="email" 
                                       id="email" 
                                       name="email" 
                                       class="form-control" 
                                       placeholder="nama@contoh.com" 
                                       required>
                            </div>

                            <div class="form-group">
                                <label for="topik" class="form-label">TOPIK</label>
                                <input type="text" 
                                       id="topik" 
                                       name="topik" 
                                       class="form-control" 
                                       placeholder="Misalnya: Kerja sama event, produksi video, talent, dll." 
                                       required>
                            </div>

                            <div class="form-group">
                                <label for="pesan" class="form-label">PESAN</label>
                                <textarea id="pesan" 
                                          name="pesan" 
                                          class="form-control" 
                                          rows="5" 
                                          placeholder="Ceritakan kebutuhan Anda secara singkat." 
                                          required></textarea>
                            </div>

                            <div class="form-group mb-0">
                                <button type="submit" class="btn-submit">
                                    Kirim Pesan
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
                
                <!-- Contact Info -->
                <div class="col-lg-5 contact-info-section">
                    <div class="contact-info-inner">
                        <div class="info-item">
                            <div class="info-header-with-icon">
                                <div class="info-icon-wrapper" style="background: linear-gradient(135deg, #6b3c3c 0%, #8b4513 100%);">
                                    <i class="fas fa-envelope"></i>
                                </div>
                                <div class="info-label">EMAIL</div>
                            </div>
                            <div class="info-value">
                                <a href="mailto:creative@madaniyatsi.com">creative@madaniyatsi.com</a>
                            </div>
                        </div>

                        <div class="info-item">
                            <div class="info-header-with-icon">
                                <div class="info-icon-wrapper" style="background: linear-gradient(135deg, #25D366 0%, #128C7E 100%);">
                                    <i class="fab fa-whatsapp"></i>
                                </div>
                                <div class="info-label">WHATSAPP / PHONE</div>
                            </div>
                            <div class="info-value">
                                <a href="tel:+6281234567890">+62 812-3456-7890</a>
                            </div>
                        </div>

                        <div class="info-item">
                            <div class="info-header-with-icon">
                                <div class="info-icon-wrapper" style="background: linear-gradient(135deg, #005f62 0%, #004a4d 100%);">
                                    <i class="fas fa-clock"></i>
                                </div>
                                <div class="info-label">JAM OPERASIONAL</div>
                            </div>
                            <div class="info-value">Senin–Jumat, 09.00–18.00 WIB</div>
                        </div>

                        <div class="info-item">
                            <div class="info-header-with-icon">
                                <div class="info-icon-wrapper" style="background: linear-gradient(135deg, #6b3c3c 0%, #8b4513 100%);">
                                    <i class="fas fa-map-marker-alt"></i>
                                </div>
                                <div class="info-label">KANTOR</div>
                            </div>
                            <div class="info-value">
                                Madani Yatsi Creative Industry<br>
                                Tangerang, Banten
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<style>
.contact-section {
    background-color: #f4f0eb;
    min-height: 80vh;
    padding: 4rem 0;
}

.contact-card-wrapper {
    max-width: 1000px;
    margin: 0 auto;
    background: #faf8f5;
    border-radius: 20px;
    box-shadow: 0 10px 40px rgba(0, 0, 0, 0.1);
    overflow: hidden;
}

.contact-form-section {
    background: white;
    padding: 0;
}

.contact-form-inner {
    padding: 3rem;
}

.contact-title {
    font-size: 2rem;
    font-weight: 700;
    color: #333;
    margin-bottom: 1rem;
    letter-spacing: 0.02em;
}

.contact-intro {
    color: #555;
    font-size: 1rem;
    line-height: 1.7;
    margin-bottom: 2.5rem;
}

.contact-form {
    margin-top: 2rem;
}

.form-group {
    margin-bottom: 1.75rem;
}

.form-label {
    display: block;
    font-weight: 600;
    color: #333;
    font-size: 0.85rem;
    margin-bottom: 0.5rem;
    text-transform: uppercase;
    letter-spacing: 0.05em;
}

.form-control {
    width: 100%;
    padding: 0.875rem 1rem;
    border: 1px solid #e3ded6;
    border-radius: 8px;
    font-size: 1rem;
    transition: all 0.3s ease;
    background: white;
    font-family: inherit;
    color: #333;
}

.form-control:focus {
    border-color: #007c82;
    outline: none;
    box-shadow: 0 0 0 3px rgba(0, 124, 130, 0.1);
}

.form-control::placeholder {
    color: #999;
}

textarea.form-control {
    resize: vertical;
    min-height: 120px;
}

.btn-submit {
    width: 100%;
    padding: 1rem 2rem;
    background-color: #007c82;
    border: none;
    border-radius: 8px;
    color: white;
    font-weight: 600;
    font-size: 1rem;
    cursor: pointer;
    transition: all 0.3s ease;
}

.btn-submit:hover {
    background-color: #005f62;
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(0, 124, 130, 0.3);
}

.btn-submit:active {
    transform: translateY(0);
}

.contact-info-section {
    background: #faf8f5;
    padding: 0;
    border-left: 1px solid #e3ded6;
}

.contact-info-inner {
    padding: 3rem;
    height: 100%;
    display: flex;
    flex-direction: column;
    justify-content: center;
}

.info-item {
    margin-bottom: 2.5rem;
    padding-left: 0.5rem;
}

.info-item:last-child {
    margin-bottom: 0;
}

.info-header-with-icon {
    display: flex;
    align-items: center;
    gap: 1rem;
    margin-bottom: 0.75rem;
}

.info-icon-wrapper {
    width: 45px;
    height: 45px;
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    flex-shrink: 0;
    box-shadow: 0 4px 15px rgba(0, 0, 0, 0.15);
    transition: all 0.3s ease;
}

.info-item:hover .info-icon-wrapper {
    transform: scale(1.1) rotate(5deg);
    box-shadow: 0 6px 20px rgba(0, 0, 0, 0.2);
}

.info-icon-wrapper i {
    font-size: 1.25rem;
    color: white;
}

.info-label {
    font-size: 0.75rem;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 0.1em;
    color: #666;
    margin: 0;
}

.info-value {
    font-size: 1rem;
    color: #333;
    line-height: 1.6;
    font-weight: 500;
}

.info-value a {
    color: #007c82;
    text-decoration: none;
    transition: color 0.3s ease;
}

.info-value a:hover {
    color: #005f62;
    text-decoration: underline;
}

/* Responsive */
@media (max-width: 991px) {
    .contact-info-section {
        border-left: none;
        border-top: 1px solid #e3ded6;
    }

    .contact-form-inner,
    .contact-info-inner {
        padding: 2rem;
    }
}

@media (max-width: 768px) {
    .contact-section {
        padding: 2rem 0;
    }

    .contact-card-wrapper {
        border-radius: 15px;
        margin: 0 1rem;
    }

    .contact-title {
        font-size: 1.75rem;
    }

    .contact-form-inner,
    .contact-info-inner {
        padding: 1.5rem;
    }

    .contact-intro {
        font-size: 0.95rem;
        margin-bottom: 2rem;
    }

    .info-item {
        margin-bottom: 2rem;
    }
}
</style>

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">

<?= $this->endSection() ?>
