<?= $this->extend('layout/admin/admin_layout') ?>

<?= $this->section('content') ?>

<style>
    * {
        margin: 0;
        padding: 0;
        box-sizing: border-box;
    }

    body {
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        background-color: #f4f0eb;
        min-height: 100vh;
        position: relative;
        overflow-x: hidden;
    }

    /* Content wrapper */
    .form-wrapper {
        position: relative;
        z-index: 1;
        padding: 40px 20px;
    }

    .form-container {
        max-width: 900px;
        margin: 0 auto;
    }

    /* Form card */
    .form-card {
        background: rgba(255, 255, 255, 0.95);
        backdrop-filter: blur(20px);
        -webkit-backdrop-filter: blur(20px);
        border-radius: 25px;
        padding: 2.5rem;
        box-shadow: 0 20px 60px rgba(0, 0, 0, 0.15);
        border: 1px solid rgba(255, 255, 255, 0.3);
        animation: fadeInUp 0.6s ease;
    }

    @keyframes fadeInUp {
        from {
            opacity: 0;
            transform: translateY(30px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    /* Page header */
    .page-header {
        text-align: center;
        margin-bottom: 2.5rem;
        padding-bottom: 1.5rem;
        border-bottom: 2px solid rgba(0, 124, 130, 0.15);
        position: relative;
    }

    .page-header::after {
        content: '';
        position: absolute;
        bottom: -2px;
        left: 50%;
        transform: translateX(-50%);
        width: 80px;
        height: 3px;
        background: linear-gradient(90deg, #007c82, #005f62);
        border-radius: 2px;
    }

    .page-header h2 {
        color: #1a1a2e;
        font-weight: 700;
        font-size: 2rem;
        margin-bottom: 0.5rem;
        letter-spacing: 0.02em;
    }

    .page-header i {
        color: #007c82;
        font-size: 2.5rem;
        margin-bottom: 0.75rem;
        display: block;
    }

    .page-header p {
        color: #666;
        font-size: 0.95rem;
        margin: 0;
    }

    /* Alert styling */
    .alert {
        border-radius: 15px;
        border: none;
        box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
        backdrop-filter: blur(10px);
        -webkit-backdrop-filter: blur(10px);
        animation: slideInDown 0.5s ease;
        margin-bottom: 1.5rem;
    }

    @keyframes slideInDown {
        from {
            opacity: 0;
            transform: translateY(-20px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    .alert-danger {
        background: rgba(220, 53, 69, 0.9);
        color: white;
    }

    /* Form group styling */
    .form-group {
        margin-bottom: 2rem;
    }

    .form-group label {
        font-weight: 600;
        color: #1a1a2e;
        margin-bottom: 0.75rem;
        display: block;
        font-size: 0.95rem;
        text-transform: uppercase;
        letter-spacing: 0.05em;
    }

    .form-group label i {
        color: #007c82;
        margin-right: 0.5rem;
        font-size: 1rem;
    }

    .form-group label .text-danger {
        color: #dc3545;
    }

    .form-control {
        border: 2px solid rgba(0, 124, 130, 0.2);
        border-radius: 12px;
        padding: 14px 18px;
        font-size: 1rem;
        transition: all 0.3s ease;
        background: #fafafa;
        width: 100%;
    }

    .form-control:focus {
        border-color: #007c82;
        box-shadow: 0 0 0 4px rgba(0, 124, 130, 0.1);
        outline: none;
        background: #fff;
    }

    .form-control::placeholder {
        color: #999;
        font-style: italic;
    }

    /* Textarea specific styling */
    textarea.form-control {
        min-height: 300px;
        resize: vertical;
        font-family: inherit;
        line-height: 1.7;
    }

    textarea.form-control:focus {
        min-height: 350px;
    }

    /* Character counter */
    .char-counter {
        text-align: right;
        font-size: 0.85rem;
        color: #999;
        margin-top: 0.5rem;
    }

    .char-counter.warning {
        color: #ff9800;
    }

    .char-counter.danger {
        color: #dc3545;
    }

    /* Button group */
    .btn-group-custom {
        display: flex;
        gap: 1rem;
        margin-top: 2.5rem;
        padding-top: 2rem;
        border-top: 2px solid rgba(0, 124, 130, 0.1);
    }

    .btn-custom {
        padding: 14px 32px;
        border-radius: 12px;
        font-weight: 600;
        font-size: 1rem;
        border: none;
        transition: all 0.3s ease;
        display: inline-flex;
        align-items: center;
        justify-content: center;
        gap: 8px;
        text-decoration: none;
        cursor: pointer;
        text-transform: uppercase;
        letter-spacing: 0.05em;
        flex: 1;
        box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
    }

    .btn-custom i {
        font-size: 1.1rem;
    }

    .btn-primary-custom {
        background: linear-gradient(135deg, #007c82 0%, #005f62 100%);
        color: white;
        box-shadow: 0 4px 20px rgba(0, 124, 130, 0.4);
    }

    .btn-primary-custom:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 25px rgba(0, 124, 130, 0.5);
        color: white;
        text-decoration: none;
        background: linear-gradient(135deg, #005f62 0%, #004a4d 100%);
    }

    .btn-secondary-custom {
        background: linear-gradient(135deg, #6c757d 0%, #5a6268 100%);
        color: white;
        box-shadow: 0 4px 20px rgba(108, 117, 125, 0.3);
    }

    .btn-secondary-custom:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 25px rgba(108, 117, 125, 0.4);
        color: white;
        text-decoration: none;
        background: linear-gradient(135deg, #5a6268 0%, #495057 100%);
    }

    /* Form tips */
    .form-tips {
        background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
        border-radius: 12px;
        padding: 1.25rem;
        margin-top: 1.5rem;
        border-left: 4px solid #007c82;
    }

    .form-tips h6 {
        color: #007c82;
        font-weight: 600;
        margin-bottom: 0.75rem;
        font-size: 0.9rem;
        text-transform: uppercase;
        letter-spacing: 0.05em;
    }

    .form-tips ul {
        margin: 0;
        padding-left: 1.25rem;
        color: #666;
        font-size: 0.9rem;
        line-height: 1.8;
    }

    .form-tips ul li {
        margin-bottom: 0.5rem;
    }

    /* Responsive */
    @media (max-width: 768px) {
        .form-wrapper {
            padding: 20px 15px;
        }

        .form-card {
            padding: 1.5rem;
            border-radius: 20px;
        }

        .page-header h2 {
            font-size: 1.5rem;
        }

        .page-header i {
            font-size: 2rem;
        }

        .btn-group-custom {
            flex-direction: column;
        }

        .btn-custom {
            width: 100%;
        }

        textarea.form-control {
            min-height: 250px;
        }

        textarea.form-control:focus {
            min-height: 300px;
        }
    }
</style>

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">

<div class="form-wrapper">
    <div class="form-container">
        <div class="form-card">
            <div class="page-header">
                <i class="fas fa-plus-circle"></i>
                <h2>Tambah Berita Baru</h2>
                <p>Buat artikel berita yang menarik dan informatif</p>
            </div>

            <?php if (session()->getFlashdata('errors')): ?>
                <div class="alert alert-danger">
                    <ul class="mb-0">
                        <?php foreach (session()->getFlashdata('errors') as $error): ?>
                            <li><?= $error ?></li>
                        <?php endforeach; ?>
                    </ul>
                </div>
            <?php endif; ?>

            <form action="" method="post" id="text-editor">
                <?= csrf_field() ?>
                
                <div class="form-group">
                    <label for="title">
                        <i class="fas fa-heading"></i> Judul Berita <span class="text-danger">*</span>
                    </label>
                    <input type="text" 
                           name="title" 
                           id="title" 
                           class="form-control" 
                           placeholder="Masukkan judul berita yang menarik..." 
                           required
                           maxlength="200">
                    <div class="char-counter">
                        <span id="title-char-count">0</span>/200 karakter
                    </div>
                </div>

                <div class="form-group">
                    <label for="content">
                        <i class="fas fa-align-left"></i> Konten Berita <span class="text-danger">*</span>
                    </label>
                    <textarea name="content" 
                              id="content" 
                              class="form-control" 
                              cols="30" 
                              rows="10" 
                              placeholder="Tulis konten berita Anda di sini. Gunakan paragraf yang jelas dan mudah dibaca..."
                              required></textarea>
                    <div class="char-counter">
                        <span id="content-char-count">0</span> karakter
                    </div>
                </div>

                <div class="form-tips">
                    <h6><i class="fas fa-lightbulb"></i> Tips Menulis Berita</h6>
                    <ul>
                        <li>Gunakan judul yang menarik dan informatif</li>
                        <li>Mulai dengan paragraf pembuka yang kuat</li>
                        <li>Gunakan paragraf pendek untuk keterbacaan yang lebih baik</li>
                        <li>Periksa ejaan dan tata bahasa sebelum mempublish</li>
                    </ul>
                </div>

                <div class="btn-group-custom">
                    <button type="submit" 
                            name="status" 
                            value="published" 
                            class="btn-custom btn-primary-custom">
                        <i class="fas fa-paper-plane"></i>
                        Publish
                    </button>
                    <button type="submit" 
                            name="status" 
                            value="draft" 
                            class="btn-custom btn-secondary-custom">
                        <i class="fas fa-save"></i>
                        Simpan sebagai Draft
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
// Character counter for title
document.addEventListener('DOMContentLoaded', function() {
    const titleInput = document.getElementById('title');
    const titleCharCount = document.getElementById('title-char-count');
    const contentTextarea = document.getElementById('content');
    const contentCharCount = document.getElementById('content-char-count');

    if (titleInput && titleCharCount) {
        titleInput.addEventListener('input', function() {
            const length = this.value.length;
            titleCharCount.textContent = length;
            
            // Update counter color based on length
            const counter = this.nextElementSibling;
            counter.classList.remove('warning', 'danger');
            if (length > 150) {
                counter.classList.add('warning');
            }
            if (length >= 200) {
                counter.classList.add('danger');
            }
        });
    }

    if (contentTextarea && contentCharCount) {
        contentTextarea.addEventListener('input', function() {
            const length = this.value.length;
            contentCharCount.textContent = length;
        });
    }
});
</script>

<?= $this->endSection() ?>
