<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class AddSocialColumnsToUsers extends Migration
{
    public function up()
    {
        $fields = [
            'provider' => [
                'type'       => 'VARCHAR',
                'constraint' => 50,
                'null'       => true,
            ],
            'provider_id' => [
                'type'       => 'VARCHAR',
                'constraint' => 190,
                'null'       => true,
            ],
            'avatar' => [
                'type'       => 'VARCHAR',
                'constraint' => 255,
                'null'       => true,
            ],
        ];

        $this->forge->addColumn('users', $fields);
    }

    public function down()
    {
        $this->forge->dropColumn('users', ['provider', 'provider_id', 'avatar']);
    }
}








