<?php namespace App\Controllers;

use App\Models\PegawaiModel;
use CodeIgniter\Exceptions\PageNotFoundException;

class PegawaiAdmin extends BaseController
{
	protected $pegawaiModel;

	public function __construct()
	{
		$this->pegawaiModel = new PegawaiModel();
	}

	public function index()
	{
		$request = service('request');
		$keyword = $request->getGet('q');
		$gender  = $request->getGet('gender') ?? 'semua';

		$data = [
			'title' => 'Data Pegawai - Admin',
			'pegawai' => $this->pegawaiModel->getFiltered($keyword, $gender),
			'keyword' => $keyword,
			'gender'  => $gender,
		];

		return view('admin/pegawai/index', $data);
	}

	public function create()
	{
		// Validasi
		$validation = \Config\Services::validation();
		$validation->setRules([
			'nama_pegawai' => 'required|min_length[3]',
			'tanggal_lahir' => 'permit_empty|valid_date',
			'jenis_kelamin' => 'required|in_list[laki-laki,perempuan]',
			'divisi' => 'required'
		]);

		$isDataValid = $validation->withRequest($this->request)->run();

		// Jika data valid, simpan ke database
		if ($isDataValid) {
			$file = $this->request->getFile('foto_pegawai');
			$fotoName = null;

			// Upload foto jika ada
			if ($file && $file->isValid() && !$file->hasMoved()) {
				$fotoName = $file->getRandomName();
				$file->move(ROOTPATH . 'public/uploads/pegawai', $fotoName);
			}

			// Siapkan data untuk insert
			$dataInsert = [
				'nama_pegawai' => $this->request->getPost('nama_pegawai'),
				'jenis_kelamin' => $this->request->getPost('jenis_kelamin'),
				'foto_pegawai' => $fotoName,
				'divisi' => $this->request->getPost('divisi')
			];

			// Tambahkan tanggal_lahir jika ada
			$tanggalLahir = $this->request->getPost('tanggal_lahir');
			if (!empty($tanggalLahir)) {
				$dataInsert['tanggal_lahir'] = $tanggalLahir;
			}

			$this->pegawaiModel->insert($dataInsert);

			return redirect()->to('/admin/pegawai')->with('success', 'Data pegawai berhasil ditambahkan');
		}

		// Tampilkan form create
		$data = [
			'title' => 'Tambah Data Pegawai'
		];
		return view('admin/pegawai/create', $data);
	}

	public function edit($id)
	{
		// Ambil data pegawai yang akan diedit
		$data['pegawai'] = $this->pegawaiModel->where('id_pegawai', $id)->first();

		if (!$data['pegawai']) {
			throw PageNotFoundException::forPageNotFound();
		}

		// Validasi
		$validation = \Config\Services::validation();
		$validation->setRules([
			'nama_pegawai' => 'required|min_length[3]',
			'tanggal_lahir' => 'permit_empty|valid_date',
			'jenis_kelamin' => 'required|in_list[laki-laki,perempuan]',
			'divisi' => 'required'
		]);

		$isDataValid = $validation->withRequest($this->request)->run();

		// Jika data valid, simpan ke database
		if ($isDataValid) {
			$file = $this->request->getFile('foto_pegawai');
			$fotoName = $data['pegawai']['foto_pegawai']; // Default: foto lama

			// Upload foto baru jika ada
			if ($file && $file->isValid() && !$file->hasMoved()) {
				// Hapus foto lama jika ada
				if ($fotoName && file_exists(ROOTPATH . 'public/uploads/pegawai/' . $fotoName)) {
					unlink(ROOTPATH . 'public/uploads/pegawai/' . $fotoName);
				}

				$fotoName = $file->getRandomName();
				$file->move(ROOTPATH . 'public/uploads/pegawai', $fotoName);
			}

			// Siapkan data untuk update
			$dataUpdate = [
				'nama_pegawai' => $this->request->getPost('nama_pegawai'),
				'jenis_kelamin' => $this->request->getPost('jenis_kelamin'),
				'foto_pegawai' => $fotoName,
				'divisi' => $this->request->getPost('divisi')
			];

			// Tambahkan tanggal_lahir jika ada
			$tanggalLahir = $this->request->getPost('tanggal_lahir');
			if (!empty($tanggalLahir)) {
				$dataUpdate['tanggal_lahir'] = $tanggalLahir;
			} else {
				// Jika kosong, set ke null
				$dataUpdate['tanggal_lahir'] = null;
			}

			$this->pegawaiModel->update($id, $dataUpdate);

			return redirect()->to('/admin/pegawai')->with('success', 'Data pegawai berhasil diupdate');
		}

		// Tampilkan form edit
		$data['title'] = 'Edit Data Pegawai';
		return view('admin/pegawai/edit', $data);
	}

	public function delete($id)
	{
		$pegawai = $this->pegawaiModel->where('id_pegawai', $id)->first();

		if ($pegawai) {
			// Hapus foto jika ada
			if ($pegawai['foto_pegawai'] && file_exists(ROOTPATH . 'public/uploads/pegawai/' . $pegawai['foto_pegawai'])) {
				unlink(ROOTPATH . 'public/uploads/pegawai/' . $pegawai['foto_pegawai']);
			}

			$this->pegawaiModel->delete($id);
			return redirect()->to('/admin/pegawai')->with('success', 'Data pegawai berhasil dihapus');
		}

		return redirect()->to('/admin/pegawai')->with('error', 'Data pegawai tidak ditemukan');
	}
}



