<?php

use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes
 */
$routes->get('/', 'Auth::login');

$routes->get('about', 'Page::about');
$routes->get('contact', 'Page::contact');
$routes->get('faqs', 'Page::faqs');
$routes->get('/news', 'News::index');
$routes->get('/news/(:any)', 'News:: viewNews/$1');
$routes->get('/pegawai', 'Pegawai::index');

// Auth routes
$routes->get('login', 'Auth::login');
$routes->post('auth/processLogin', 'Auth::processLogin');
$routes->get('auth/logout', 'Auth::logout');
$routes->get('auth/google', 'Auth::redirectToGoogle');
$routes->get('auth/google/callback', 'Auth::handleGoogleCallback');
$routes->get('auth/facebook', 'Auth::redirectToFacebook');
$routes->get('auth/facebook/callback', 'Auth::handleFacebookCallback');

$routes->group('admin', ['filter' => 'auth'], function($routes){
	$routes->get('news', 'NewsAdmin::index');
	$routes->get('news/(:segment)/preview', 'NewsAdmin::preview/$1');
    $routes->add('news/new', 'NewsAdmin::create');
	$routes->add('news/(:segment)/edit', 'NewsAdmin::edit/$1');
	$routes->get('news/(:segment)/delete', 'NewsAdmin::delete/$1');
	
	// Pegawai routes
	$routes->get('pegawai', 'PegawaiAdmin::index');
	$routes->add('pegawai/create', 'PegawaiAdmin::create');
	$routes->add('pegawai/(:segment)/edit', 'PegawaiAdmin::edit/$1');
	$routes->get('pegawai/(:segment)/delete', 'PegawaiAdmin::delete/$1');
});
