<?= $this->extend('layout/frontend') ?>

<?= $this->section('content') ?>

<div class="text-center mb-12">
    <h1 class="text-4xl font-bold text-gray-800 mb-4">Biodata & Profil</h1>
    <p class="text-gray-600">Detail profesional dan informasi kontak.</p>
</div>

<div class="max-w-4xl mx-auto mb-12">
    <form action="" method="get" class="bg-white p-4 rounded-xl shadow-sm border border-brown-50 flex flex-col md:flex-row gap-4">
        <div class="flex-1 relative">
            <i data-lucide="search" class="absolute left-3 top-3 text-gray-400 w-5 h-5"></i>
            <input type="text" name="keyword" value="<?= esc($keyword) ?>" placeholder="Cari nama atau ringkasan..." class="w-full pl-10 border-gray-200 border rounded-lg px-4 py-2 focus:ring-2 focus:ring-brown-400 focus:border-transparent outline-none">
        </div>
        <button type="submit" class="bg-brown-500 text-white px-8 py-2 rounded-lg font-medium hover:bg-brown-600 transition">
            Cari
        </button>
    </form>
</div>

<div class="grid gap-8 max-w-5xl mx-auto">
    <?php foreach ($biodata as $index => $item): ?>
    <div class="bg-white p-10 rounded-[2rem] shadow-xl hover:shadow-2xl transition duration-500 border border-brown-50 flex flex-col md:flex-row gap-10 items-start md:items-center animate-fade-in-up md:hover:-translate-x-2" style="animation-delay: <?= $index * 0.1 ?>s;">
        <div class="w-40 h-40 bg-brown-50 rounded-full flex-shrink-0 flex items-center justify-center text-brown-400 mx-auto md:mx-0 shadow-inner border-4 border-white ring-4 ring-brown-100 overflow-hidden">
            <?php if ($item['photo']): ?>
                <img src="<?= base_url('uploads/biodata/' . $item['photo']) ?>" alt="<?= esc($item['name']) ?>" class="w-full h-full object-cover">
            <?php else: ?>
                <i data-lucide="user" class="w-20 h-20"></i>
            <?php endif; ?>
        </div>
        <div class="flex-1 text-center md:text-left">
            <div class="mb-4">
                <h2 class="text-3xl font-extrabold text-gray-800 mb-1 tracking-tight">Naisyela Farrakh Nabila</h2>
                <span class="inline-block bg-brown-100 text-brown-700 px-3 py-1 rounded-full text-xs font-bold uppercase tracking-wide">Profil Profesional</span>
            </div>
            
            <p class="text-gray-600 leading-relaxed mb-6 text-lg">
                <?= esc($item['summary']) ?>
            </p>

            <div class="flex flex-wrap gap-4 justify-center md:justify-start">
                <a href="mailto:naisyelafnabila@gmail.com" class="flex items-center px-4 py-2 bg-gray-50 rounded-lg text-gray-700 hover:bg-brown-50 hover:text-brown-700 transition font-medium border border-gray-200">
                    <i data-lucide="mail" class="w-4 h-4 mr-2"></i> naisyelafnabila@gmail.com
                </a>
                <div class="flex items-center px-4 py-2 bg-gray-50 rounded-lg text-gray-700 hover:bg-brown-50 hover:text-brown-700 transition font-medium border border-gray-200">
                    <i data-lucide="phone" class="w-4 h-4 mr-2"></i> 083879866394
                </div>
                <div class="flex items-center px-4 py-2 bg-gray-50 rounded-lg text-gray-700 hover:bg-brown-50 hover:text-brown-700 transition font-medium border border-gray-200">
                    <i data-lucide="map-pin" class="w-4 h-4 mr-2"></i> Kp. Sema Ds. Koper Kec. Cikande Kab. Serang Prov. Banten
                </div>
            </div>
        </div>
    </div>
    <?php endforeach; ?>
</div>

<?= $this->endSection() ?>
