<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class CreateEducationTable extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [
                'type'           => 'INT',
                'constraint'     => 11,
                'unsigned'       => true,
                'auto_increment' => true,
            ],
            'level' => [
                'type'       => 'VARCHAR',
                'constraint' => '100',
            ],
            'school_name' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
            ],
            'start_year' => [
                'type'       => 'YEAR',
            ],
            'end_year' => [
                'type'       => 'YEAR',
            ],
            'created_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'updated_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
        ]);
        $this->forge->addKey('id', true);
        $this->forge->createTable('education');
    }

    public function down()
    {
        $this->forge->dropTable('education');
    }
}
