<?php

namespace App\Controllers;

use App\Models\ActivityModel;
use App\Models\BiodataModel;
use App\Models\EducationModel;

class Home extends BaseController
{
    public function index()
    {
        return view('frontend/index', [
            'recent_activities' => (new ActivityModel())->orderBy('date', 'desc')->findAll(4),
            'biodata_count'     => (new BiodataModel())->countAll(),
        ]);
    }

    public function activities()
    {
        $model = new ActivityModel();
        
        $keyword = $this->request->getGet('keyword');
        $sort    = $this->request->getGet('sort') ?? 'date';
        $order   = $this->request->getGet('order') ?? 'desc';

        $builder = $model->orderBy($sort, $order);

        if ($keyword) {
            $builder->like('activity_name', $keyword)->orLike('date', $keyword);
        }

        $data = [
            'activities' => $builder->limit(4)->find(), 
            // 'pager'      => $model->pager, // Removed pager as we strictly limit to 3
            'keyword'    => $keyword,
            'sort'       => $sort,
            'order'      => $order,
        ];

        return view('frontend/activities', $data);
    }

    public function biodata()
    {
        $model = new BiodataModel();

        $keyword = $this->request->getGet('keyword');
        $sort    = $this->request->getGet('sort') ?? 'name';
        $order   = $this->request->getGet('order') ?? 'asc';

        $builder = $model->orderBy($sort, $order);

        if ($keyword) {
            $builder->like('name', $keyword)->orLike('summary', $keyword);
        }

        $data = [
            'biodata' => $builder->paginate(10),
            'pager'   => $model->pager,
            'keyword'   => $keyword,
            'sort'      => $sort,
            'order'     => $order,
        ];

        return view('frontend/biodata', $data);
    }

    public function education()
    {
        $model = new EducationModel();

        $keyword = $this->request->getGet('keyword');
        $sort    = $this->request->getGet('sort') ?? 'start_year';
        $order   = $this->request->getGet('order') ?? 'asc';

        $builder = $model->orderBy($sort, $order);

        if ($keyword) {
            $builder->like('school_name', $keyword)->orLike('level', $keyword);
        }

        $data = [
            'education' => $builder->paginate(10),
            'pager'     => $model->pager,
            'keyword'   => $keyword,
            'sort'      => $sort,
            'order'     => $order,
        ];

        return view('frontend/education', $data);
    }
}