<?php

namespace App\Controllers;

use App\Controllers\BaseController;

class AuthController extends BaseController
{
    public function login()
    {
        return view('auth/login');
    }

    public function auth()
    {
        // Simulasi login sukses untuk demo tampilan
        // Pada implementasi nyata, ini akan memverifikasi database
        $username = $this->request->getPost('username');
        $password = $this->request->getPost('password');

        if ($username && $password) {
            session()->set('isLoggedIn', true);
            return redirect()->to('/admin');
        }

        return redirect()->back()->withInput()->with('error', 'Username atau password salah');
    }

    public function logout()
    {
        session()->destroy();
        return redirect()->to('/login');
    }
}
