<?= $this->extend('layout/page_layout') ?>

<?= $this->section('content') ?>

<style>
	/* HERO AREA */
	.dashboard-hero {
		background: linear-gradient(135deg, #0d47a1 0%, #1565c0 100%);
		color: white;
		padding: 60px 0;
		text-align: center;
		margin-bottom: 40px;
		border-radius: 12px;
		box-shadow: 0 4px 15px rgba(0,0,0,0.18);
	}

	.dashboard-hero h1 {
		font-size: 2.8rem;
		font-weight: 700;
		margin-bottom: 10px;
	}

	.dashboard-hero p {
		font-size: 1.15rem;
		opacity: .92;
	}

	/* SECTION TITLE */
	.section-title {
		font-size: 1.8rem;
		font-weight: 700;
		color: #0d47a1;
		margin-bottom: 20px;
		margin-top: 20px;
		text-align: center;
	}

	/* CARDS */
	.dashboard-card {
		border: none;
		border-radius: 14px;
		padding: 35px 28px;
		background: white;
		box-shadow: 0 5px 20px rgba(0,0,0,0.10);
		transition: all .35s ease;
		text-align: center;
		margin-bottom: 28px;
	}

	.dashboard-card:hover {
		transform: translateY(-6px);
		box-shadow: 0 15px 32px rgba(0,0,0,0.15);
	}

	.card-icon {
		font-size: 46px;
		margin-bottom: 18px;
		color: #1976d2;
	}

	.dashboard-card h5 {
		font-size: 1.3rem;
		font-weight: 700;
		color: #0d47a1;
		margin-bottom: 12px;
	}

	.dashboard-card p {
		color: #546e7a;
		font-size: 1rem;
		line-height: 1.7;
	}

	/* VISI MISI STYLE */
	.info-box {
		background: #ffffff;
		border-radius: 14px;
		padding: 25px;
		box-shadow: 0 5px 20px rgba(0,0,0,0.10);
		margin-bottom: 25px;
	}

	.info-box h3 {
		font-size: 1.5rem;
		font-weight: 700;
		color: #0d47a1;
		margin-bottom: 15px;
	}

	.info-box p,
	.info-box li {
		font-size: 1rem;
		color: #455a64;
		line-height: 1.7;
	}

	.info-list {
		padding-left: 20px;
	}

	.info-list li {
		margin-bottom: 8px;
	}
</style>



<!-- HERO HEADER -->
<div class="dashboard-hero">
	<h1>Marketing Management Dashboard</h1>
	<p>Manajemen Strategis Pemasaran Perusahaan Secara Profesional & Terstruktur</p>
</div>



<div class="container">

	<!-- VISI -->
	<h2 class="section-title">Visi Departemen Marketing</h2>
	<div class="info-box">
		<p>
			Menjadi departemen pemasaran yang inovatif, modern, dan berorientasi pada data untuk 
			mendukung pertumbuhan perusahaan secara berkelanjutan serta memperkuat posisi merek di pasar.
		</p>
	</div>

	<!-- MISI -->
	<h2 class="section-title">Misi Departemen Marketing</h2>
	<div class="info-box">
		<ul class="info-list">
			<li>Membangun strategi pemasaran yang efektif dan relevan dengan perkembangan pasar.</li>
			<li>Meningkatkan brand awareness melalui kampanye digital dan strategi konten kreatif.</li>
			<li>Mengoptimalkan analisis data untuk pengambilan keputusan pemasaran.</li>
			<li>Mengembangkan hubungan kuat dengan pelanggan melalui pendekatan customer-centric.</li>
			<li>Mendorong inovasi dalam strategi branding dan komunikasi publik.</li>
		</ul>
	</div>

	<!-- CORE VALUES -->
	<h2 class="section-title">Nilai-Nilai Utama (Core Values)</h2>
	<div class="info-box">
		<ul class="info-list">
			<li><strong>Integrity:</strong> Transparan dan bertanggung jawab dalam setiap aktivitas pemasaran.</li>
			<li><strong>Creativity:</strong> Menghadirkan ide-ide baru untuk memenangkan kompetisi pasar.</li>
			<li><strong>Data-Driven:</strong> Setiap keputusan berbasis analisis dan riset.</li>
			<li><strong>Collaboration:</strong> Bekerja lintas divisi untuk mencapai target perusahaan.</li>
			<li><strong>Professionalism:</strong> Menjaga kualitas kerja dan komunikasi yang elegan.</li>
		</ul>
	</div>

	<!-- TUJUAN -->
	<h2 class="section-title">Tujuan Departemen Marketing</h2>
	<div class="info-box">
		<ul class="info-list">
			<li>Meningkatkan efektivitas strategi pemasaran perusahaan.</li>
			<li>Mengoptimalkan penggunaan platform digital untuk promosi.</li>
			<li>Meningkatkan konversi dan loyalitas pelanggan.</li>
			<li>Menghasilkan laporan performa marketing yang akurat dan transparan.</li>
			<li>Mendorong pertumbuhan pendapatan melalui strategi pemasaran yang agresif dan terukur.</li>
		</ul>
	</div>




	<!-- KOMPONEN UTAMA MARKETING -->
	<h2 class="section-title">Fokus Utama Departemen Marketing</h2>
	<div class="row">

		<!-- CARD 1 -->
		<div class="col-lg-6 col-md-6 col-sm-12">
			<div class="dashboard-card">
				<div class="card-icon">📊</div>
				<h5>Market Research & Insights</h5>
				<p>
					Analisis pasar, segmentasi audiens, dan riset kompetitor sebagai dasar pengambilan keputusan strategis.
				</p>
			</div>
		</div>

		<!-- CARD 2 -->
		<div class="col-lg-6 col-md-6 col-sm-12">
			<div class="dashboard-card">
				<div class="card-icon">🎨</div>
				<h5>Branding & Creative Strategy</h5>
				<p>
					Pengembangan identitas merek, desain visual, serta kreativitas konten untuk memperkuat komunikasi perusahaan.
				</p>
			</div>
		</div>

		<!-- CARD 3 -->
		<div class="col-lg-6 col-md-6 col-sm-12">
			<div class="dashboard-card">
				<div class="card-icon">🚀</div>
				<h5>Digital Campaign Management</h5>
				<p>
					Perencanaan kampanye digital di berbagai platform untuk meningkatkan visibilitas dan konversi pelanggan.
				</p>
			</div>
		</div>

		<!-- CARD 4 -->
		<div class="col-lg-6 col-md-6 col-sm-12">
			<div class="dashboard-card">
				<div class="card-icon">📈</div>
				<h5>Performance & Analytics</h5>
				<p>
					Pengukuran KPI, analitik trafik, dan optimasi promosi berbasis data untuk hasil yang maksimal.
				</p>
			</div>
		</div>

	</div>
</div>

<?= $this->endSection() ?>
