<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard - Marketing</title>

    <link rel="stylesheet" href="<?= base_url('css/bootstrap.min.css') ?>">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">

    <style>
        body {
            background-color: #eef2f7;
            font-family: 'Poppins', sans-serif;
        }

        .content-wrapper {
            padding: 25px;
        }

        .header-box {
            background: white;
            padding: 20px;
            border-radius: 10px;
            margin-bottom: 25px;
            box-shadow: 0 3px 10px rgba(0,0,0,0.05);
        }

        .header-box h2 {
            margin: 0;
            font-weight: 600;
            color: #1e3c72;
        }
    </style>
</head>

<body>

    <?= $this->include('layout/admin/navbar') ?>

    <div class="container content-wrapper">
        <div class="header-box">
            <h2><?= $title ?? 'Dashboard Admin' ?></h2>
        </div>

        <?= $this->renderSection('content') ?>
    </div>

    <script src="<?= base_url('js/jquery.min.js') ?>"></script>
    <script src="<?= base_url('js/bootstrap.min.js') ?>"></script>

</body>
</html>
