<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login Admin Marketing</title>

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">

    <style>
        body {
            background: linear-gradient(135deg, #1e3c72, #2a5298, #5dade2);
            min-height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
            padding: 20px;
            font-family: 'Poppins', sans-serif;
            color: #eee;
        }

        .login-box {
            background: #ffffff;
            padding: 35px;
            width: 100%;
            max-width: 400px;
            border-radius: 18px;
            box-shadow: 0 12px 32px rgba(0,0,0,0.18);
            border: 1px solid rgba(255,255,255,0.5);
        }

        .login-title {
            text-align: center;
            margin-bottom: 25px;
        }

        .login-title h2 {
            font-size: 1.8rem;
            font-weight: 700;
            margin-top: 10px;
            color: #1e3c72;
        }

        .login-title p {
            margin: 0;
            font-size: 0.95rem;
            color: #6b7280;
        }

        .form-label {
            font-weight: 600;
            color: #1e3c72;
        }

        .form-control {
            border-radius: 10px;
            border: 1.5px solid #d0d0d0;
            padding: 11px 13px;
            transition: 0.2s;
        }

        .form-control:focus {
            border-color: #2a5298;
            box-shadow: 0 0 0 0.18rem rgba(42, 82, 152, 0.25);
        }

        .password-wrapper {
            position: relative;
        }

        .password-toggle {
            position: absolute;
            right: 12px;
            top: 50%;
            transform: translateY(-50%);
            background: none;
            border: none;
            cursor: pointer;
            font-size: 1.15rem;
            color: #6a6a6a;
        }

        /* Tombol Biru Fresh */
        .btn-login {
            width: 100%;
            padding: 11px;
            border-radius: 10px;
            margin-top: 10px;
            font-weight: 600;
            background: linear-gradient(135deg, #1e3c72, #2a5298, #5dade2);
            border: none;
            color: #fff;
            transition: 0.25s;
        }

        .btn-login:hover {
            transform: translateY(-3px);
            box-shadow: 0 6px 18px rgba(30, 60, 114, 0.35);
        }

        .alert {
            border-radius: 10px;
            font-size: 0.9rem;
        }
    </style>
</head>

<body>

<div class="login-box">

    <div class="login-title">
        <i class="bi bi-shield-lock-fill fs-1" style="color:#2a5298;"></i>
        <h2>Login Admin</h2>
        <p>Akses Dashboard Marketing</p>
    </div>

    <?php if(session()->getFlashdata('error')): ?>
        <div class="alert alert-danger">
            <i class="bi bi-x-circle me-1"></i>
            <?= session()->getFlashdata('error') ?>
        </div>
    <?php endif; ?>

    <?php if(session()->getFlashdata('success')): ?>
        <div class="alert alert-success">
            <i class="bi bi-check-circle me-1"></i>
            <?= session()->getFlashdata('success') ?>
        </div>
    <?php endif; ?>

    <form action="/admin/login" method="post">
        <?= csrf_field() ?>

        <div class="mb-3">
            <label class="form-label">Username</label>
            <input type="text" class="form-control" name="username" required placeholder="Masukkan username">
        </div>

        <div class="mb-3">
            <label class="form-label">Password</label>
            <div class="password-wrapper">
                <input type="password" class="form-control" id="password" name="password" required placeholder="Masukkan password">
                <button type="button" class="password-toggle" id="togglePassword">
                    <i class="bi bi-eye" id="eyeIcon"></i>
                </button>
            </div>
        </div>

        <button type="submit" class="btn btn-login">
            <i class="bi bi-box-arrow-in-right me-1"></i> Login
        </button>
    </form>

</div>

<script>
    const togglePassword = document.getElementById("togglePassword");
    const passwordInput = document.getElementById("password");
    const eyeIcon = document.getElementById("eyeIcon");

    togglePassword.addEventListener("click", function () {
        const type = passwordInput.type === "password" ? "text" : "password";
        passwordInput.type = type;

        eyeIcon.classList.toggle("bi-eye");
        eyeIcon.classList.toggle("bi-eye-slash");
    });
</script>

</body>
</html>
