<?= $this->extend('layout/page_layout') ?>
<?= $this->section('content') ?>

<style>
    .hero {
        background: #1565c0;
        color: white;
        padding: 40px 0;
        text-align: center;
        margin-bottom: 30px;
    }

    .contact-box {
        background: #fff;
        border-radius: 10px;
        padding: 25px;
        box-shadow: 0 3px 15px rgba(0,0,0,0.1);
        margin-bottom: 30px;
    }

    .info-item {
        display: flex;
        align-items: center;
        margin-bottom: 15px;
        padding: 10px;
        background: #f7f7f7;
        border-radius: 8px;
    }

    .info-item i {
        font-size: 1.4rem;
        color: #1565c0;
        margin-right: 15px;
    }

    .form-label {
        font-weight: 600;
    }

    .btn-send {
        background: #1565c0;
        color: white;
        border: none;
        padding: 10px;
        border-radius: 8px;
        width: 100%;
        font-weight: 600;
    }

    .btn-send:hover {
        background: #5567d9;
        color: white;
    }

    .is-invalid {
        border-color: #dc3545 !important;
    }
</style>

<div class="hero">
    <h2>Hubungi Kami</h2>
    <p>Kami siap membantu Anda kapan saja.</p>
</div>

<div class="container">
    <div class="row">

        <!-- Info Kontak -->
        <div class="col-md-5 mb-4">
            <div class="contact-box">
                <h4 class="mb-3">Informasi Kontak</h4>

                <div class="info-item">
                    <i class="bi bi-building"></i>
                    <div>
                        <strong>Department Marketing</strong><br>
                        <?= isset($name) ? esc($name) : 'Universitas Yatsi Madani' ?>
                    </div>
                </div>

                <div class="info-item">
                    <i class="bi bi-envelope"></i>
                    <div>
                        <strong>Email</strong><br>
                        marketing@example.com
                    </div>
                </div>

                <div class="info-item">
                    <i class="bi bi-telephone"></i>
                    <div>
                        <strong>Telepon</strong><br>
                        +62 85719678058
                    </div>
                </div>

                <div class="info-item">
                    <i class="bi bi-clock"></i>
                    <div>
                        <strong>Jam Operasional</strong><br>
                        Senin–Jumat: 09.00–17.00<br>
                        Sabtu–Minggu: 12.00–17.00
                    </div>
                </div>
            </div>
        </div>

        <!-- Form Kontak -->
        <div class="col-md-7">
            <div class="contact-box">

                <h4 class="mb-3">Kirim Pesan</h4>

                <!-- Flash message -->
                <?php if(session()->getFlashdata('success')): ?>
                    <div class="alert alert-success"><?= session()->getFlashdata('success') ?></div>
                <?php endif; ?>

                <?php if(session()->getFlashdata('error')): ?>
                    <div class="alert alert-danger"><?= session()->getFlashdata('error') ?></div>
                <?php endif; ?>

                <!-- Form -->
                <form action="<?= base_url('contact') ?>" method="post" id="contactForm">
                    <?= csrf_field() ?>

                    <div class="mb-3">
                        <label class="form-label">Nama Lengkap</label>
                        <input type="text" 
                               name="name" 
                               class="form-control <?= (isset($validation) && $validation->hasError('name')) ? 'is-invalid' : '' ?>"
                               value="<?= old('name') ?>"
                               required>
                        <?php if(isset($validation) && $validation->hasError('name')): ?>
                            <div class="text-danger small"><?= $validation->getError('name') ?></div>
                        <?php endif; ?>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Email</label>
                        <input type="email"
                               name="email"
                               class="form-control <?= (isset($validation) && $validation->hasError('email')) ? 'is-invalid' : '' ?>"
                               value="<?= old('email') ?>"
                               required>
                        <?php if(isset($validation) && $validation->hasError('email')): ?>
                            <div class="text-danger small"><?= $validation->getError('email') ?></div>
                        <?php endif; ?>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Pesan</label>
                        <textarea name="message"
                                  rows="5"
                                  class="form-control <?= (isset($validation) && $validation->hasError('message')) ? 'is-invalid' : '' ?>"
                                  required><?= old('message') ?></textarea>
                        <?php if(isset($validation) && $validation->hasError('message')): ?>
                            <div class="text-danger small"><?= $validation->getError('message') ?></div>
                        <?php endif; ?>
                    </div>

                    <button type="submit" class="btn-send">Kirim Pesan</button>
                </form>

            </div>
        </div>

    </div>
</div>

<?= $this->endSection() ?>
