<?= $this->extend('layout/admin/admin_layout') ?>
<?= $this->section('content') ?>

<div class="container-fluid">

    <!-- HEADER CARD -->
    <div class="card p-3 shadow mb-4" style="border-radius: 15px; border: none;">
        <div class="d-flex flex-column flex-md-row justify-content-between align-items-center gap-3">
            <div class="d-flex align-items-center gap-2" style="
                background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
                padding: 1rem;
                border-radius: 12px;
                color: white;
                font-weight: 700;
                font-size: 1.25rem;
            ">
                <i class="bi bi-people-fill" style="font-size: 1.7rem;"></i>
                <span>Daftar Pegawai Marketing</span>
            </div>
            <a href="<?= base_url('admin/pegawai/create') ?>" 
               class="btn"
               style="
                   background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
                   border: none;
                   padding: 10px 18px;
                   color: white;
                   font-weight: 600;
                   border-radius: 10px;
                   transition: 0.3s;
               "
               onmouseover="this.style.opacity='0.85'"
               onmouseout="this.style.opacity='1'"
            >
                <i class="bi bi-plus-circle me-2"></i>Tambah Pegawai
            </a>
        </div>
          <p class="mt-3 text-muted fw-bold" style="font-size:0.95rem;">
             Kelola daftar pegawai marketing.
          </p>
       </div>

<!-- FILTER / SEARCH -->
<div class="card p-3 shadow mb-4" style="border-radius: 15px;">
    <form method="get" class="row g-3 align-items-end">
        <div class="col-md-4">
            <label class="form-label fw-semibold">Cari</label>
            <input type="text" name="keyword" class="form-control"
                   placeholder="Nama, tanggal, gender" value="<?= esc($keyword ?? '') ?>"
                   style="border-radius:10px; border:1px solid #e2e8f0; color:#2d3748; font-size:0.95rem;">
        </div>
        <div class="col-md-3">
            <label class="form-label fw-semibold">Gender</label>
            <select name="gender" class="form-select"
                    style="border-radius:10px; border:1px solid #e2e8f0; color:#2d3748; font-size:0.95rem;">
                <option value="">Semua Gender</option>
                <option value="laki-laki" <?= ($gender ?? '')=='laki-laki'?'selected':'' ?>>Laki-laki</option>
                <option value="perempuan" <?= ($gender ?? '')=='perempuan'?'selected':'' ?>>Perempuan</option>
            </select>
        </div>
        <div class="col-md-2">
            <button class="btn w-100"
                    style="background: linear-gradient(135deg,#667eea 0%,#764ba2 100%);
                           color:white; font-weight:600; border:none; border-radius:10px; transition:0.3s;"
                    onmouseover="this.style.opacity='0.85'"
                    onmouseout="this.style.opacity='1'">
                <i class="bi bi-search me-1"></i> Cari
            </button>
        </div>
        <div class="col-md-3">
            <a href="<?= base_url('admin/pegawai') ?>" class="btn w-100"
               style="background: #a0aec0; color:white; font-weight:600; border:none; border-radius:10px; transition:0.3s;"
               onmouseover="this.style.opacity='0.85'"
               onmouseout="this.style.opacity='1'">
                Reset
            </a>
        </div>
    </form>
</div>


    <!-- TABEL PEGAWAI -->
    <div class="card p-3 shadow news-table-container mb-4" style="border-radius: 15px;">
        <?php if(empty($pegawai)): ?>
            <div class="empty-state">
                <i class="bi bi-inbox"></i>
                <h4>Belum ada pegawai</h4>
                <p>Mulai dengan menambahkan pegawai baru</p>
                <a href="<?= base_url('admin/pegawai/create') ?>" class="btn mt-2"
                   style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
                          border: none; padding:8px 18px; color:white; font-weight:600; border-radius:10px;">
                    <i class="bi bi-plus-circle me-2"></i>Tambah Pegawai
                </a>
            </div>
        <?php else: ?>
            <div class="table-responsive">
                <table class="table align-middle table-hover">
                    <thead class="text-muted">
                        <tr>
                            <th>No</th>
                            <th>Foto</th>
                            <th>Nama</th>
                            <th>Gender</th>
                            <th>Divisi</th>
                            <th>Tgl Lahir</th>
                            <th style="width:220px;">Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach($pegawai as $i=>$row): ?>
                        <tr>
                            <td><?= $i+1 ?></td>
                            <td>
                                <?php if($row['foto_pegawai']): ?>
                                    <img src="<?= base_url('uploads/pegawai/'.$row['foto_pegawai']) ?>"
                                         style="width:60px;height:60px;border-radius:10px;object-fit:cover;border:2px solid #eee;">
                                <?php else: ?>
                                    <span class="text-muted">Tidak ada foto</span>
                                <?php endif ?>
                            </td>
                            <td><?= esc($row['nama_pegawai']) ?></td>
                            <td><?= $row['jenis_kelamin'] ?></td>
                            <td><?= esc($row['divisi']) ?></td>
                            <td><?= date('d M Y', strtotime($row['tanggal_lahir'])) ?></td>
                            <td class="d-flex gap-2">
                               <a href="<?= base_url('admin/pegawai/preview/'.$row['id_pegawai']) ?>" class="btn-action btn-preview">
                               <i class="bi bi-eye me-1"></i>Preview
                               </a>
                               <a href="<?= base_url('admin/pegawai/edit/'.$row['id_pegawai']) ?>" class="btn-action btn-edit"><i class="bi bi-pencil me-1"></i>Edit</a>
                               <a href="#" data-href="<?= base_url('admin/pegawai/delete/'.$row['id_pegawai']) ?>" onclick="confirmToDelete(this)" class="btn-action btn-delete"><i class="bi bi-trash me-1"></i>Delete</a>
                            </td>
                        </tr>
                        <?php endforeach ?>
                    </tbody>
                </table>
            </div>
        <?php endif ?>
    </div>

</div>

<!-- MODAL DELETE -->
<div id="confirm-dialog" class="modal fade" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><i class="bi bi-exclamation-triangle-fill text-warning me-2"></i>Konfirmasi Hapus</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <h2>Apakah Anda yakin?</h2>
                <p>Data yang dihapus tidak dapat dikembalikan.</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><i class="bi bi-x-circle me-1"></i>Batal</button>
                <a href="#" id="delete-button" class="btn btn-danger"><i class="bi bi-trash me-1"></i>Hapus</a>
            </div>
        </div>
    </div>
</div>

<!-- CSS -->
<style>
.news-table-container {
    background: white;
    border-radius: 15px;
    box-shadow: 0 5px 20px rgba(0,0,0,0.08);
    overflow: hidden;
    animation: fadeIn 0.6s ease-out;]]]
}

.table tbody tr:hover {
    background-color: #f8f9fa;
    transform: scale(1.01);
    box-shadow: 0 2px 8px rgba(0,0,0,0.05);
}

.btn-action {
    padding: 0.5rem 1rem;
    border-radius: 8px;
    font-size: 0.85rem;
    font-weight: 600;
    margin: 0 0.25rem;
    transition: all 0.3s ease;
    border: 2px solid;
    text-decoration: none;
    display: inline-flex;
    align-items: center;
}
.btn-action {
    white-space: nowrap;  /* supaya teks tombol tidak wrap */
}


.btn-preview { background:white; color:#667eea; border-color:#667eea; }
.btn-preview:hover { background:#667eea; color:white; transform:translateY(-2px); box-shadow:0 4px 10px rgba(102,126,234,0.3); }

.btn-edit { background:white; color:#f6ad55; border-color:#f6ad55; }
.btn-edit:hover { background:#f6ad55; color:white; transform:translateY(-2px); box-shadow:0 4px 10px rgba(246,173,85,0.3); }

.btn-delete { background:white; color:#fc8181; border-color:#fc8181; }
.btn-delete:hover { background:#fc8181; color:white; transform:translateY(-2px); box-shadow:0 4px 10px rgba(252,129,129,0.3); }

.empty-state { text-align:center; padding:4rem 2rem; color:#718096; }
.empty-state i { font-size:4rem; margin-bottom:1rem; opacity:0.5; }

@keyframes fadeIn { from{opacity:0;transform:translateY(20px);} to{opacity:1;transform:translateY(0);} }
</style>

<script>
function confirmToDelete(el){
    document.getElementById('delete-button').href = el.dataset.href;
    var myModal = new bootstrap.Modal(document.getElementById('confirm-dialog'));
    myModal.show();
}
</script>

<?= $this->endSection() ?>
