<?= $this->extend('layout/page_layout') ?>
<?= $this->section('content') ?>

<style>
    /* ================= FULL WIDTH HEADER ================= */
    .marketing-header-wrapper {
        width: 100%;
        margin-bottom: 30px;
    }

    .marketing-header {
        width: 100%;
        background: linear-gradient(135deg, #0d47a1, #1565c0);
        padding: 70px 30px;
        border-radius: 0;
        color: white;
        text-align: center;
        box-shadow: 0 4px 16px rgba(0,0,0,0.15);
    }

    .marketing-header h1 {
        font-size: 2.6rem;
        font-weight: 700;
        margin-bottom: 12px;
    }

    .marketing-header p {
        font-size: 1.15rem;
        line-height: 1.6;
        opacity: .95;
        max-width: 900px;
        margin: auto;
    }

    /* ================= MAIN WRAPPER ================= */
    .marketing-wrapper {
        max-width: 1100px;
        margin: auto;
        padding: 0 15px 60px;
    }

    /* ================= CONTENT CARD ================= */
    .content-card {
        background: white;
        padding: 35px 30px;
        border-radius: 14px;
        box-shadow: 0 6px 20px rgba(0,0,0,0.12);
        margin-bottom: 30px;
    }

    .content-card p {
        font-size: 1.05rem;
        color: #34495e;
        line-height: 1.8;
        text-align: justify;
        margin-bottom: 18px;
    }

    /* ================= HIGHLIGHT BOX ================= */
    .highlight-box {
        background: #e3f2fd;
        border-left: 6px solid #1565c0;
        padding: 18px 22px;
        border-radius: 10px;
        margin: 25px 0;
    }

    .highlight-box strong {
        color: #0d47a1;
        font-size: 1.1rem;
    }

    /* ================= TEAM SECTION ================= */
    .team-section-title {
        font-size: 2rem;
        font-weight: 700;
        margin-bottom: 40px;
        text-align: center;
        color: #0d47a1;
    }

    .team-wrapper {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
        gap: 30px;
        margin-top: 30px;
    }

    .team-card {
        background: #ffffff;
        border-radius: 16px;
        padding: 25px 20px;
        box-shadow: 0 6px 20px rgba(0,0,0,0.08);
        text-align: center;
        transition: all 0.3s ease-in-out;
        display: flex;
        flex-direction: column;
        align-items: center;
    }

    .team-card:hover {
        transform: translateY(-6px);
        box-shadow: 0 10px 25px rgba(0,0,0,0.12);
    }

    .team-photo {
        width: 150px;
        height: 150px;
        object-fit: cover;
        border-radius: 50%;
        margin-bottom: 18px;
        border: 4px solid #e3f2fd;
        transition: all 0.3s ease;
    }

    .team-card:hover .team-photo {
        transform: scale(1.05);
    }

    .team-name {
        font-size: 1.2rem;
        font-weight: 700;
        margin-bottom: 6px;
        color: #2c3e50;
    }

    .team-role {
        font-size: 0.95rem;
        color: #555;
        font-weight: 500;
    }
</style>

<!-- ================= FULL WIDTH HEADER ================= -->
<div class="marketing-header-wrapper">
    <div class="marketing-header">
        <h1>Marketing Management Dashboard</h1>
        <p>Platform strategis untuk mengelola, menganalisis, dan mengoptimalkan seluruh aktivitas pemasaran perusahaan secara profesional.</p>
    </div>
</div>

<!-- ================= CONTENT AREA ================= -->
<div class="marketing-wrapper">
    <div class="content-card">
        <p>
            <strong>Marketing Management Dashboard</strong> merupakan platform strategis yang dikembangkan sebagai pusat pengelolaan seluruh aktivitas pemasaran perusahaan. Dashboard ini dirancang untuk menghadirkan transparansi, efisiensi, dan ketepatan informasi dalam setiap proses pemasaran—mulai dari perencanaan, pelaksanaan kampanye, hingga evaluasi menyeluruh.
        </p>
        <p>
            Sebagai bentuk komitmen perusahaan dalam mencapai performa pemasaran terbaik, dashboard ini menyajikan data terstruktur, analitik terukur, serta insight mendalam mengenai tren pasar dan perilaku konsumen. Informasi yang ditampilkan secara real-time memungkinkan setiap unit dalam tim marketing melakukan adaptasi dan respons cepat terhadap perubahan dinamika pasar.
        </p>
        <div class="highlight-box">
            <strong>Fokus utama dashboard ini adalah memberikan kemudahan akses informasi, pengambilan keputusan berbasis data, dan integrasi kerja yang lebih solid antar divisi marketing.</strong>
        </div>
        <p>
            Dashboard ini mencakup pengelolaan kampanye digital, pemantauan KPI, evaluasi nilai brand, serta penyusunan laporan komprehensif yang membantu perusahaan melihat perkembangan secara sistematis. Melalui integrasi sistem yang rapi, berbagai divisi—seperti branding, digital advertising, content development, dan customer engagement—dapat bekerja lebih efisien dan harmonis.
        </p>
        <p>
            Tidak hanya berfungsi sebagai alat pemantauan, <strong>Marketing Management Dashboard</strong> menjadi fondasi penting dalam membangun strategi pemasaran jangka panjang yang berkelanjutan. Dengan dukungan visualisasi data modern, analisis cerdas, dan pendekatan berbasis insight, dashboard ini membantu perusahaan meningkatkan daya saing, memperkuat positioning brand, dan mencapai target pertumbuhan yang lebih agresif.
        </p>
        <p>
            Kehadiran dashboard ini merupakan bentuk keseriusan perusahaan dalam mengadopsi teknologi pemasaran yang inovatif, sekaligus memperkuat kualitas pengambilan keputusan yang mengandalkan data akurat dan terintegrasi.
        </p>
    </div>
</div>

<!-- ================= TEAM SECTION ================= -->
<div class="content-card">
    <h2 class="team-section-title">Marketing Team</h2>
    <div class="team-wrapper">
        <?php 
        $team = [
            ["name" => "Muhamad Ridwan", "role" => "Marketing Director", "photo" => "Ridwan.jpeg"],
            ["name" => "Vira Dwi Amalia", "role" => "Communication Division", "photo" => "Vira.jpeg"],
            ["name" => "Diki Satria", "role" => "Digital Strategist", "photo" => "Diki.jpeg"],
            ["name" => "Abelia Putri", "role" => "Content Specialist", "photo" => "Abel.jpeg"],
            ["name" => "Tiara Cahya Kurniawati", "role" => "Digital Marketing Division", "photo" => "Tiara.jpeg"],
            ["name" => "Imanoel", "role" => "Creative & Production Division", "photo" => "imanoel.jpeg"],
            ["name" => "Rendi Siswanto", "role" => "Creative & Production Division", "photo" => "Rendi.jpeg"],
        ];
        ?>

        <?php foreach ($team as $member) : ?>
            <?php 
                $photoPath = FCPATH . 'img/team/' . $member['photo'];
                $photoUrl = file_exists($photoPath) 
                    ? base_url('img/team/' . $member['photo']) 
                    : base_url('img/team/default.jpg'); 
            ?>
            <div class="team-card">
                <img src="<?= $photoUrl ?>" class="team-photo" alt="Photo <?= $member['name'] ?>">
                <div class="team-name"><?= $member['name'] ?></div>
                <div class="team-role"><?= $member['role'] ?></div>
            </div>
        <?php endforeach; ?>
    </div>
</div>

<?= $this->endSection() ?>
