<?= $this->extend('layout/page_layout') ?>

<?= $this->section('content') ?>

<style>
    .faq-section {
        padding: 40px 0;
    }

    .faq-card {
        background: #ffffff;
        border-radius: 12px;
        padding: 25px 30px;
        margin-bottom: 20px;
        box-shadow: 0 4px 12px rgba(0,0,0,0.08);
        transition: all 0.25s ease;
        border-left: 5px solid #667eea;
    }

    .faq-card:hover {
        transform: translateY(-3px);
        box-shadow: 0 6px 20px rgba(0,0,0,0.12);
    }

    .faq-question {
        font-size: 1.35rem;
        font-weight: 700;
        color: #2d3748;
        margin-bottom: 10px;
    }

    .faq-answer {
        font-size: 1rem;
        color: #4a5568;
        line-height: 1.6;
    }
</style>

<div class="container faq-section">
    <div class="row justify-content-center">
        <div class="col-lg-10 col-md-12">
            <?php foreach ($data_faqs as $faq) : ?>
                <div class="faq-card">
                    <h2 class="faq-question">
                        <i class="bi bi-question-circle-fill me-2 text-primary"></i>
                        <?= esc($faq['question']) ?>
                    </h2>
                    <p class="faq-answer"><?= esc($faq['answer']) ?></p>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</div>

<?= $this->endSection() ?>
