<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\PegawaiModel;

class Pegawai extends BaseController
{
    protected $pegawaiModel;

    public function __construct()
    {
        $this->pegawaiModel = new PegawaiModel();
    }

    public function create()
    {
        helper(['form', 'url']);

        if ($this->request->getMethod() == 'post') {
            // Ambil nilai status dari tombol submit
            $status = $this->request->getPost('status'); // "aktif" atau "draft"

            // Ambil data dari form
            $data = [
                'nama_pegawai' => $this->request->getPost('nama_pegawai'),
                'tanggal_lahir' => $this->request->getPost('tanggal_lahir'),
                'jenis_kelamin' => $this->request->getPost('jenis_kelamin'),
                'status' => $status,
            ];

            // Upload foto jika ada
            $foto = $this->request->getFile('foto');
            if ($foto && $foto->isValid() && !$foto->hasMoved()) {
                $newName = $foto->getRandomName();
                $foto->move(WRITEPATH . 'uploads', $newName);
                $data['foto'] = $newName;
            }

            // Simpan ke database
            $this->pegawaiModel->insert($data);

            return redirect()->to('/pegawai'); // redirect ke halaman list pegawai
        }

        return view('admin/pegawai_form'); // form view
    }
}
