<?php namespace App\Controllers;

use \App\Models\NewsModel;
use CodeIgniter\Exceptions\PageNotFoundException;

class NewsAdmin extends BaseController
{
	/**
	 * Cek apakah admin sudah login
	 * Mengembalikan redirect response jika belum login, null jika sudah login
	 */
	private function checkLogin()
	{
		$session = session();
		$loggedIn = $session->get('logged_in_admin');
		$adminUsername = $session->get('admin_username');
		
		// Cek apakah admin sudah login
		if (!$loggedIn || !$adminUsername) {
			// Set flash message untuk memberi tahu user
			$session->setFlashdata('error', 'Anda harus login terlebih dahulu untuk mengakses halaman ini.');
			// Redirect ke login
			return redirect()->to('/admin/login');
		}
		return null;
	}

	public function index()
	{
		// Cek login terlebih dahulu
		$check = $this->checkLogin();
		if ($check !== null) {
			return $check;
		}

        $news = new NewsModel();
        $data['newses'] = $news->findAll();
		echo view('admin_list_news', $data);
    }
    //--------------------------------------------------------------------------
        public function preview($id)
	{
		// Cek login terlebih dahulu
		$check = $this->checkLogin();
		if ($check !== null) {
			return $check;
		}

		$news = new NewsModel();
		$data['news'] = $news->where('id', $id)->first();
		
		if(!$data['news']){
			throw PageNotFoundException::forPageNotFound();
		}
		echo view('news_detail', $data);
    }
    //--------------------------------------------------------------------------
        public function create()
    {
		// Cek login terlebih dahulu
		$check = $this->checkLogin();
		if ($check !== null) {
			return $check;
		}

        // lakukan validasi
        $validation =  \Config\Services::validation();
        $validation->setRules(['title' => 'required']);
        $isDataValid = $validation->withRequest($this->request)->run();

        // jika data valid, simpan ke database
        if($isDataValid){
            $news = new NewsModel();
            $news->insert([
                "title" => $this->request->getPost('title'),
                "content" => $this->request->getPost('content'),
                "status" => $this->request->getPost('status'),
                "slug" => url_title($this->request->getPost('title'), '-', TRUE)
            ]);
            return redirect('admin/news');
        }
		
        // tampilkan form create
        echo view('admin_create_news');
    }

    //--------------------------------------------------------------------------

    public function edit($id)
    {
		// Cek login terlebih dahulu
		$check = $this->checkLogin();
		if ($check !== null) {
			return $check;
		}

        // ambil artikel yang akan diedit
        $news = new NewsModel();
        $data['news'] = $news->where('id', $id)->first();
        
        // lakukan validasi data artikel
        $validation =  \Config\Services::validation();
        $validation->setRules([
            'id' => 'required',
            'title' => 'required'
        ]);
        $isDataValid = $validation->withRequest($this->request)->run();
        // jika data vlid, maka simpan ke database
        if($isDataValid){
            $news->update($id, [
                "title" => $this->request->getPost('title'),
                "content" => $this->request->getPost('content'),
                "status" => $this->request->getPost('status')
            ]);
            return redirect('admin/news');
        }

        // tampilkan form edit
        echo view('admin_edit_news', $data);
    }

    //--------------------------------------------------------------------------

	public function delete($id){
		// Cek login terlebih dahulu
		$check = $this->checkLogin();
		if ($check !== null) {
			return $check;
		}

        $news = new NewsModel();
        $news->delete($id);
        return redirect('admin/news');
    }
}