<?php

namespace App\Controllers;

use App\Controllers\BaseController;

class AdminDashboard extends BaseController
{
    public function index()
    {
        // Pastikan admin sudah login
        $session = session();
        $loggedIn = $session->get('logged_in_admin');
        $adminUsername = $session->get('admin_username');
        
        if (!$loggedIn || !$adminUsername) {
            $session->setFlashdata('error', 'Anda harus login terlebih dahulu untuk mengakses halaman ini.');
            return redirect()->to('/admin/login');
        }

        return view('admin/dashboard');
    }

    public function logout()
    {
        session()->destroy();
        return redirect()->to('/admin/login');
    }
}
