<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\PegawaiModel;

class Pegawai extends BaseController
{
    protected $pegawaiModel;

    public function __construct()
    {
        $this->pegawaiModel = new PegawaiModel();
    }

    public function index()
    {
        $keyword = $this->request->getGet('keyword');
        $gender  = $this->request->getGet('gender');

        $builder = $this->pegawaiModel;

        if ($keyword) {
            $builder->like('nama_pegawai', $keyword)
                    ->orLike('tanggal_lahir', $keyword)
                    ->orLike('jenis_kelamin', $keyword);
        }

        if ($gender) {
            $builder->where('jenis_kelamin', $gender);
        }

        $data['pegawai'] = $builder->findAll();
        $data['keyword'] = $keyword;
        $data['gender']  = $gender;

        return view('admin/pegawai/index', $data);
    }

    public function create()
{
    // Hardcode daftar divisi supaya view bisa pakai
    $data['divisi'] = [
        ['nama_divisi' => 'IT'],
        ['nama_divisi' => 'Marketing'],
        ['nama_divisi' => 'Produksi'],
        ['nama_divisi' => 'HR']
    ];

    return view('admin/pegawai/create', $data); // pastikan $data dikirim ke view
}

    public function store()
    {
        $foto = $this->request->getFile('foto_pegawai');
        $namaFoto = '';

        if ($foto && $foto->isValid() && !$foto->hasMoved()) {
            $namaFoto = $foto->getRandomName();
            $foto->move('uploads/pegawai', $namaFoto);
        }

        $this->pegawaiModel->save([
            'nama_pegawai'   => $this->request->getPost('nama_pegawai'),
            'tanggal_lahir'  => $this->request->getPost('tanggal_lahir'),
            'jenis_kelamin'  => $this->request->getPost('jenis_kelamin'),
            'foto_pegawai'   => $namaFoto,
        ]);

        return redirect()->to('/admin/pegawai');
    }

    public function detail($id)
    {
        $data['detail'] = $this->pegawaiModel->find($id);

        if (!$data['detail']) {
            throw new \CodeIgniter\Exceptions\PageNotFoundException("Pegawai tidak ditemukan.");
        }

        return view('admin/pegawai/detail', $data);
    }

    public function preview($id)
{
    // Ambil data pegawai
    $pegawai = $this->pegawaiModel->find($id);

    // Jika tidak ditemukan, tampilkan 404
    if (!$pegawai) {
        throw \CodeIgniter\Exceptions\PageNotFoundException("Pegawai tidak ditemukan.");
    }

    // Kirim data ke view detail
    return view('admin/pegawai/detail', [
        'pegawai' => $pegawai
    ]);
}

    public function edit($id)
{
    $data['pegawai'] = $this->pegawaiModel->find($id);

    if (!$data['pegawai']) {
        throw new \CodeIgniter\Exceptions\PageNotFoundException("Data pegawai tidak ditemukan.");
    }

    // Hardcode sementara daftar divisi
    $data['divisi'] = [
        ['nama_divisi' => 'IT'],
        ['nama_divisi' => 'Marketing'],
        ['nama_divisi' => 'Produksi'],
        ['nama_divisi' => 'HR']
    ];

    return view('admin/pegawai/edit', $data);
}


    public function update($id)
    {
        $pegawai = $this->pegawaiModel->find($id);

        if (!$pegawai) {
            throw new \CodeIgniter\Exceptions\PageNotFoundException("Pegawai tidak ditemukan!");
        }

        $fotoBaru = $this->request->getFile('foto_pegawai');
        $namaFoto = $pegawai['foto_pegawai'];

        // Jika upload foto baru
        if ($fotoBaru->isValid() && !$fotoBaru->hasMoved()) {
            $namaFoto = $fotoBaru->getRandomName();
            $fotoBaru->move('uploads/pegawai', $namaFoto);

            // hapus foto lama
            if (is_file('uploads/pegawai/' . $pegawai['foto_pegawai'])) {
                unlink('uploads/pegawai/' . $pegawai['foto_pegawai']);
            }
        }

        $this->pegawaiModel->update($id, [
    'nama_pegawai'   => $this->request->getPost('nama_pegawai'),
    'tanggal_lahir'  => $this->request->getPost('tanggal_lahir'),
    'jenis_kelamin'  => $this->request->getPost('jenis_kelamin'),
    'divisi'         => $this->request->getPost('divisi'),
    'foto_pegawai'   => $namaFoto,
]);


        return redirect()->to('/admin/pegawai');
    }

    public function delete($id)
    {
        $pegawai = $this->pegawaiModel->find($id);

        if ($pegawai && is_file('uploads/pegawai/' . $pegawai['foto_pegawai'])) {
            unlink('uploads/pegawai/' . $pegawai['foto_pegawai']);
        }

        $this->pegawaiModel->delete($id);

        return redirect()->to('/admin/pegawai');
    }
}
