<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Test Aktivitas Save</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            max-width: 800px;
            margin: 50px auto;
            padding: 20px;
            background: #f5f5f5;
        }
        .card {
            background: white;
            padding: 30px;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        h2 { color: #333; margin-top: 0; }
        .form-group {
            margin-bottom: 20px;
        }
        label {
            display: block;
            margin-bottom: 5px;
            font-weight: bold;
            color: #555;
        }
        input, textarea {
            width: 100%;
            padding: 10px;
            border: 1px solid #ddd;
            border-radius: 4px;
            font-size: 14px;
            box-sizing: border-box;
        }
        textarea {
            min-height: 100px;
            resize: vertical;
        }
        button {
            background: #5b7fff;
            color: white;
            padding: 12px 30px;
            border: none;
            border-radius: 4px;
            font-size: 16px;
            cursor: pointer;
        }
        button:hover {
            background: #4a6eee;
        }
        .alert {
            padding: 15px;
            margin-bottom: 20px;
            border-radius: 4px;
        }
        .alert-success {
            background: #d4edda;
            color: #155724;
            border: 1px solid #c3e6cb;
        }
        .alert-danger {
            background: #f8d7da;
            color: #721c24;
            border: 1px solid #f5c6cb;
        }
    </style>
</head>
<body>
    <div class="card">
        <h2>Test Form - Tambah Aktivitas</h2>
        <p style="color: #666; margin-bottom: 20px;">
            Form ini akan mengirim data langsung ke endpoint CodeIgniter untuk testing.
        </p>

        <form action="http://localhost:8080/admin/aktivitas/save" method="POST">
            <div class="form-group">
                <label for="tanggal">Tanggal</label>
                <input type="date" id="tanggal" name="tanggal" value="<?= date('Y-m-d'); ?>" required>
            </div>

            <div class="form-group">
                <label for="nama_aktivitas">Nama Aktivitas</label>
                <input type="text" id="nama_aktivitas" name="nama_aktivitas" value="Test Activity - <?= date('H:i:s'); ?>" required>
            </div>

            <div class="form-group">
                <label for="keterangan">Keterangan</label>
                <textarea id="keterangan" name="keterangan" required>Ini adalah test aktivitas yang dibuat pada <?= date('Y-m-d H:i:s'); ?></textarea>
            </div>

            <button type="submit">Simpan Aktivitas</button>
        </form>

        <div style="margin-top: 30px; padding-top: 20px; border-top: 1px solid #eee;">
            <h3 style="margin-top: 0;">Debug Info:</h3>
            <ul style="color: #666; font-size: 14px;">
                <li>Target URL: <code>http://localhost:8080/admin/aktivitas/save</code></li>
                <li>Method: POST</li>
                <li>Note: CSRF token tidak disertakan dalam form ini untuk testing</li>
            </ul>
        </div>
    </div>
</body>
</html>
