<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\UserModel;

class Profile extends BaseController
{
    public function index()
    {
        helper('form');
        return view('admin/profile/password', [
            'title' => 'Ganti Password',
            'validation' => \Config\Services::validation()
        ]);
    }

    public function updatePassword()
    {
        $rules = [
            'current_password' => 'required',
            'new_password'     => 'required|min_length[5]',
            'confirm_password' => 'required|matches[new_password]'
        ];

        if (!$this->validate($rules)) {
            return redirect()->back()->withInput();
        }

        $userModel = new UserModel();
        $user = $userModel->find(session()->get('user_id'));

        // Verify current password
        if (!password_verify($this->request->getVar('current_password'), $user['password_hash'])) {
            return redirect()->back()->withInput()->with('error', 'Password saat ini salah.');
        }

        // Update password
        $userModel->update($user['id'], [
            'password_hash' => password_hash($this->request->getVar('new_password'), PASSWORD_DEFAULT)
        ]);

        return redirect()->to('/admin/profile/password')->with('success', 'Password berhasil diubah.');
    }
}
