<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Portal Berita CodeIgniter</title>

    <link rel="stylesheet" href="<?= base_url('css/bootstrap.min.css') ?>" />
    <link rel="stylesheet" href="<?= base_url('css/app.css') ?>" />
</head>

<body class="app-shell">

    <?= $this->include('layout/navbar') ?>
    <?php if (! isset($showHeader) || $showHeader !== false): ?>
        <?= $this->include('layout/header') ?>
    <?php endif; ?>

    <main class="app-main">
        <div class="container app-container">
            <div class="row g-4 align-items-start">
                <div class="col-12 col-lg-8">
                    <?= $this->renderSection('content') ?>
                </div>
                <div class="col-12 col-lg-4">
                    <?= $this->include('layout/sidebar') ?>
                </div>
            </div>
        </div>
    </main>

    <?= $this->include('layout/footer') ?>

    <script src="<?= base_url('js/jquery-3.7.1.min.js') ?>"></script>
    <script>
        if (typeof window.jQuery === 'undefined') {
            const fallback = document.createElement('script');
            fallback.src = 'https://code.jquery.com/jquery-3.7.1.min.js';
            document.head.appendChild(fallback);
        }
    </script>
    <script src="<?= base_url('js/bootstrap.bundle.min.js') ?>"></script>
    <script>
        if (typeof window.bootstrap === 'undefined') {
            const fallback = document.createElement('script');
            fallback.src = 'https://cdn.jsdelivr.net/npm/bootstrap@4.5.2/dist/js/bootstrap.bundle.min.js';
            document.body.appendChild(fallback);
        }
    </script>
    <script>
        // Fallback untuk navbar toggle jika Bootstrap tidak bekerja
        document.addEventListener('DOMContentLoaded', function() {
            const navbarToggler = document.querySelector('.navbar-toggler');
            const navbarCollapse = document.querySelector('#navbarNav');
            
            if (navbarToggler && navbarCollapse) {
                navbarToggler.addEventListener('click', function(e) {
                    e.preventDefault();
                    navbarCollapse.classList.toggle('show');
                    const isExpanded = navbarCollapse.classList.contains('show');
                    navbarToggler.setAttribute('aria-expanded', isExpanded);
                });
                
                // Tutup menu saat klik di luar
                document.addEventListener('click', function(e) {
                    if (!navbarToggler.contains(e.target) && !navbarCollapse.contains(e.target)) {
                        navbarCollapse.classList.remove('show');
                        navbarToggler.setAttribute('aria-expanded', 'false');
                    }
                });
            }

            // Scroll Animation dengan Intersection Observer
            const observerOptions = {
                threshold: 0.1,
                rootMargin: '0px 0px -50px 0px'
            };

            const observer = new IntersectionObserver(function(entries) {
                entries.forEach(entry => {
                    if (entry.isIntersecting) {
                        entry.target.classList.add('visible');
                        observer.unobserve(entry.target);
                    }
                });
            }, observerOptions);

            // Tambahkan class fade-in-on-scroll ke elemen yang ingin di-animate
            const animateElements = document.querySelectorAll('.news-card, .sidebar-card, .card-surface');
            animateElements.forEach((el, index) => {
                el.classList.add('fade-in-on-scroll');
                el.style.transitionDelay = (index * 0.1) + 's';
                observer.observe(el);
            });

            // Navbar scroll effect
            const navbar = document.querySelector('.app-navbar');
            if (navbar) {
                window.addEventListener('scroll', function() {
                    if (window.pageYOffset > 50) {
                        navbar.classList.add('scrolled');
                    } else {
                        navbar.classList.remove('scrolled');
                    }
                });
            }
        });
    </script>
</body>

</html>
