<?php
    $logoCandidates = ['media/logoPT.png', 'logoPT.png', 'media/logo.png'];
    $logoAsset      = null;

    foreach ($logoCandidates as $candidate) {
        $relative = ltrim($candidate, '/');
        $path     = FCPATH . $relative;

        if (is_file($path)) {
            $logoAsset = base_url($relative) . '?v=' . filemtime($path);
            break;
        }
    }

    $companyName = 'MADANI YATSI CREATIVE';

    $initials = 'MY';
    $parts    = preg_split('/\s+/', trim($companyName));
    if (is_array($parts) && count($parts) > 0) {
        $initials = strtoupper(substr($parts[0], 0, 1) . substr(end($parts), 0, 1));
    }

    $uri       = service('uri');
    $current   = trim($uri->getPath(), '/');
    $isActive  = static function (array $targets) use ($current): bool {
        foreach ($targets as $target) {
            if ($target === '' && $current === '') {
                return true;
            }

            if ($target !== '' && strpos($current, $target) === 0) {
                return true;
            }
        }

        return false;
    };
?>
<nav class="navbar navbar-expand-lg navbar-dark app-navbar">
    <div class="container">
        <a class="navbar-brand d-flex align-items-center" href="<?= base_url() ?>">
            <span class="brand-mark">
                <?php if ($logoAsset): ?>
                    <img src="<?= esc($logoAsset) ?>" alt="Logo <?= esc($companyName) ?>" loading="lazy">
                <?php else: ?>
                    <span class="brand-initials"><?= esc($initials) ?></span>
                <?php endif; ?>
            </span>
            <span><?= esc($companyName) ?></span>
        </a>
        <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse justify-content-end" id="navbarNav">
            <ul class="navbar-nav align-items-lg-center gap-lg-1">
                <li class="nav-item">
                    <a class="nav-link <?= $isActive(['']) ? 'active' : '' ?>" href="<?= base_url() ?>">Beranda</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?= $isActive(['news']) ? 'active' : '' ?>" href="<?= base_url('news') ?>">News</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?= $isActive(['about']) ? 'active' : '' ?>" href="<?= base_url('about') ?>">About</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?= $isActive(['contact']) ? 'active' : '' ?>" href="<?= base_url('contact') ?>">Contact</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?= $isActive(['faqs']) ? 'active' : '' ?>" href="<?= base_url('faqs') ?>">Faqs</a>
                </li>
            </ul>
        </div>
    </div>
</nav>