<?php
    $bannerCandidates = ['media/banner.png', 'media/baner.png', 'banner.png', 'baner.png'];
    $bannerAsset      = null;

    foreach ($bannerCandidates as $candidate) {
        $relative = ltrim($candidate, '/');
        $path     = FCPATH . $relative;

        if (is_file($path)) {
            $bannerAsset = base_url($relative) . '?v=' . filemtime($path);
            break;
        }
    }
?>
<header class="app-hero <?= $bannerAsset ? 'app-hero--with-media' : '' ?>">
    <div class="container">
        <div class="app-hero__grid">
            <div>
                <span class="app-hero__badge">Portal Berita</span>
                <h1 class="app-hero__title">Sorotan terbaru dan kisah tim YAMA Creative</h1>
                <p class="app-hero__lead">Ikuti perkembangan produk, acara perusahaan, dan inisiatif digital yang sedang kami kerjakan untuk klien serta komunitas.</p>
                <a class="app-hero__cta" href="<?= base_url('news') ?>">
                    Jelajahi berita
                    <span aria-hidden="true">→</span>
                </a>
            </div>
            <?php if ($bannerAsset): ?>
                <div class="app-hero__media">
                    <img src="<?= esc($bannerAsset) ?>" alt="Banner perusahaan" loading="lazy">
                </div>
            <?php endif; ?>
        </div>
    </div>
</header>