<?php
    $uri       = service('uri');
    $current   = trim($uri->getPath(), '/');
    $isActive  = static function (array $targets) use ($current): bool {
        foreach ($targets as $target) {
            if ($target !== '' && strpos($current, $target) === 0) {
                return true;
            }
        }
        return false;
    };

    $logoCandidates = ['media/logoPT.png', 'logoPT.png', 'media/logo.png'];
    $logoAsset      = null;

    foreach ($logoCandidates as $candidate) {
        $relative = ltrim($candidate, '/');
        $path     = FCPATH . $relative;

        if (is_file($path)) {
            $logoAsset = base_url($relative) . '?v=' . filemtime($path);
            break;
        }
    }

    $companyName = 'MADANI YATSI CREATIVE';
    $initials = 'MY';
    $parts    = preg_split('/\s+/', trim($companyName));
    if (is_array($parts) && count($parts) > 0) {
        $initials = strtoupper(substr($parts[0], 0, 1) . substr(end($parts), 0, 1));
    }
?>
<aside class="admin-sidebar" id="adminSidebar">
    <div class="admin-sidebar__header">
        <a class="admin-sidebar__brand" href="<?= base_url('admin/dashboard') ?>">
            <div class="admin-sidebar__logo">
                <?php if ($logoAsset): ?>
                    <img src="<?= esc($logoAsset) ?>" alt="Logo <?= esc($companyName) ?>" loading="lazy">
                <?php else: ?>
                    <span class="admin-sidebar__initials"><?= esc($initials) ?></span>
                <?php endif; ?>
            </div>
            <div class="admin-sidebar__brand-text">
                <div class="admin-sidebar__brand-title">Admin Panel</div>
                <div class="admin-sidebar__brand-subtitle"><?= esc($companyName) ?></div>
            </div>
        </a>
        <button class="admin-sidebar__toggle d-lg-none" type="button" aria-label="Toggle sidebar" id="sidebarToggle">
            <span></span>
            <span></span>
            <span></span>
        </button>
    </div>

    <nav class="admin-sidebar__nav">
        <ul class="admin-sidebar__menu">
            <li class="admin-sidebar__item">
                <a class="admin-sidebar__link <?= $isActive(['admin/dashboard', 'admin']) ? 'active' : '' ?>" href="<?= base_url('admin/dashboard') ?>">
                    <span class="admin-sidebar__icon">📊</span>
                    <span class="admin-sidebar__text">Dashboard</span>
                </a>
            </li>
            <li class="admin-sidebar__item">
                <a class="admin-sidebar__link <?= $isActive(['admin/news']) ? 'active' : '' ?>" href="<?= base_url('admin/news') ?>">
                    <span class="admin-sidebar__icon">📰</span>
                    <span class="admin-sidebar__text">Berita</span>
                    <?php if ($isActive(['admin/news'])): ?>
                        <span class="admin-sidebar__badge">Aktif</span>
                    <?php endif; ?>
                </a>
            </li>
            <li class="admin-sidebar__item">
                <a class="admin-sidebar__link <?= $isActive(['admin/perusahaan']) ? 'active' : '' ?>" href="<?= base_url('admin/perusahaan') ?>">
                    <span class="admin-sidebar__icon">👥</span>
                    <span class="admin-sidebar__text">Perusahaan</span>
                    <?php if ($isActive(['admin/perusahaan'])): ?>
                        <span class="admin-sidebar__badge">Aktif</span>
                    <?php endif; ?>
                </a>
            </li>
        </ul>

        <div class="admin-sidebar__divider"></div>

        <ul class="admin-sidebar__menu">
            <li class="admin-sidebar__item">
                <a class="admin-sidebar__link" href="<?= base_url('admin/news/new') ?>">
                    <span class="admin-sidebar__icon">➕</span>
                    <span class="admin-sidebar__text">Berita Baru</span>
                </a>
            </li>
            <li class="admin-sidebar__item">
                <a class="admin-sidebar__link" href="<?= base_url('admin/setting') ?>">
                    <span class="admin-sidebar__icon">⚙️</span>
                    <span class="admin-sidebar__text">Pengaturan</span>
                </a>
            </li>
        </ul>
    </nav>

    <div class="admin-sidebar__footer">
        <a class="admin-sidebar__link admin-sidebar__link--danger" href="<?= base_url('logout') ?>">
            <span class="admin-sidebar__icon">🚪</span>
            <span class="admin-sidebar__text">Keluar</span>
        </a>
    </div>
</aside>

<div class="admin-sidebar__overlay" id="sidebarOverlay"></div>




