<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Panel Admin - <?= isset($pageTitle) ? esc($pageTitle) : 'Dashboard' ?></title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="<?= base_url('css/admin.css') ?>">
</head>
<body>
    <div class="admin-wrapper">
        <?= $this->include('layout/admin/sidebar') ?>

        <div class="admin-main">
            <header class="admin-header">
                <div class="d-flex align-items-center gap-3">
                    <button class="admin-sidebar__toggle d-lg-none" type="button" aria-label="Toggle sidebar" id="headerSidebarToggle" aria-expanded="false">
                        <span></span>
                        <span></span>
                        <span></span>
                    </button>
                    <h1 class="admin-header__title mb-0"><?= isset($pageTitle) ? esc($pageTitle) : 'Dashboard' ?></h1>
                </div>
                <div class="admin-header__actions">
                    <!-- Space for future actions -->
                </div>
            </header>

            <main class="admin-content">
                <?= $this->renderSection('content') ?>
            </main>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Sidebar toggle functionality
        const sidebar = document.getElementById('adminSidebar');
        const overlay = document.getElementById('sidebarOverlay');
        const toggleButtons = document.querySelectorAll('#sidebarToggle, #headerSidebarToggle');

        toggleButtons.forEach(btn => {
            btn?.addEventListener('click', (e) => {
                e.preventDefault();
                e.stopPropagation();
                const isOpen = sidebar?.classList.contains('show');
                sidebar?.classList.toggle('show');
                overlay?.classList.toggle('show');
                btn?.setAttribute('aria-expanded', !isOpen ? 'true' : 'false');
            });
        });

        overlay?.addEventListener('click', () => {
            sidebar?.classList.remove('show');
            overlay?.classList.remove('show');
        });

        // Close sidebar on window resize if > lg
        window.addEventListener('resize', () => {
            if (window.innerWidth >= 992) {
                sidebar?.classList.remove('show');
                overlay?.classList.remove('show');
            }
        });
    </script>
</body>
</html>
