<?= $this->extend('layout/admin/admin_layout') ?>

<?= $this->section('content') ?>
<?php
    $pegawai = $pegawai ?? [];
    $photo   = $pegawai['foto_pegawai'] ?? '';
    $photoUrl = $photo ? base_url($photo) : null;
    $backList = base_url('admin/perusahaan');
    $backPreview = base_url('admin/perusahaan/'.$pegawai['id_pegawai'].'/preview');
?>
<div class="admin-card mb-4">
    <div class="admin-card__header align-items-center">
        <div>
            <h2 class="admin-card__title mb-1">Foto Pegawai</h2>
            <p class="text-muted mb-0 small">Tinjau foto profil sebelum dibagikan ke publik.</p>
        </div>
        <div class="d-flex gap-2">
            <a href="<?= $backList ?>" class="btn btn-admin btn-admin-outline">Kembali ke Daftar</a>
            <a href="<?= $backPreview ?>" class="btn btn-admin btn-admin-primary">Lihat Preview</a>
        </div>
    </div>

    <div class="admin-card__body">
        <?php if ($photoUrl): ?>
            <div class="text-center">
                <div class="mb-3">
                    <a href="<?= esc($photoUrl) ?>" target="_blank" rel="noopener">
                        <img src="<?= esc($photoUrl) ?>"
                             alt="Foto <?= esc($pegawai['nama_pegawai'] ?? 'Pegawai') ?>"
                             class="img-fluid rounded"
                             style="max-height: 540px; object-fit: contain; box-shadow: 0 12px 30px rgba(0,0,0,0.12);">
                    </a>
                </div>
                <p class="text-muted small mb-0">Klik gambar untuk membuka ukuran penuh di tab baru.</p>
            </div>
        <?php else: ?>
            <div class="alert alert-warning mb-0" role="alert">
                Foto belum diunggah untuk pegawai ini. Tambahkan melalui menu edit.
            </div>
        <?php endif; ?>
    </div>
</div>

<?= $this->endSection() ?>
