<?php

namespace App\Controllers;

use App\Models\PegawaiModel;
use CodeIgniter\Exceptions\PageNotFoundException;

class Pegawai extends BaseController
{
    private PegawaiModel $pegawai;

    public function __construct()
    {
        $this->pegawai = new PegawaiModel();
    }

    public function detail(int $id): string
    {
        $pegawai = $this->pegawai->find($id);

        if (! $pegawai) {
            throw PageNotFoundException::forPageNotFound();
        }

        $divisiLabels = [
            'Direktur Utama' => 'Direktur Utama',
            'IT'             => 'IT (Information Technology)',
            'Produksi'       => 'Produksi',
            'Marketing'      => 'Marketing',
            'HR'             => 'HR (Human Resource)',
        ];

        $genderLabels = [
            'laki-laki' => 'Laki-laki',
            'perempuan' => 'Perempuan',
        ];

        return view('pegawai_detail', [
            'pegawai'     => $pegawai,
            'divisiLabel' => $divisiLabels[$pegawai['divisi'] ?? ''] ?? ($pegawai['divisi'] ?? '-'),
            'genderLabel' => $genderLabels[strtolower($pegawai['jenis_kelamin'] ?? '')] ?? 'Belum diisi',
            'showHeader'  => false,
        ]);
    }
}
