<?php

namespace App\Controllers;

use App\Models\NewsModel;
use CodeIgniter\Exceptions\PageNotFoundException;

class News extends BaseController
{
    private NewsModel $news;

    public function __construct()
    {
        $this->news = new NewsModel();
    }

    public function index(): string
    {
        $publishedNews = $this->news
            ->where('status', 'published')
            ->orderBy('created_at', 'desc')
            ->findAll();

        return view('news', ['newses' => $publishedNews]);
    }

    public function viewNews(string $slug): string
    {
        $news = $this->news
            ->where([
                'slug'   => $slug,
                'status' => 'published',
            ])
            ->first();

        if (! $news) {
            throw PageNotFoundException::forPageNotFound();
        }

        return view('news_detail', ['news' => $news]);
    }
}
