<?php

namespace App\Controllers;

use App\Models\AdminModel;

/**
 * Menangani proses autentikasi admin (login + logout).
 */
class Auth extends BaseController
{
    protected AdminModel $admins;

    public function __construct()
    {
        helper(['form']); // helper diperlukan untuk fungsi validasi & csrf
        $this->admins = new AdminModel();
    }

    public function login()
    {
        if (session()->get('logged_in')) {
            return redirect()->to(base_url('admin/dashboard'));
        }

        if ($this->request->is('post')) {
            $rules = [
                'email'    => 'required|valid_email',
                'password' => 'required|min_length[6]',
            ];

            if (! $this->validate($rules)) {
                // Validasi dasar gagal, kembalikan form beserta error
                return redirect()->back()->withInput()->with('errors', $this->validator->getErrors());
            }

            $email    = (string) $this->request->getPost('email');
            $password = (string) $this->request->getPost('password');

            $admin = $this->admins
                ->where('email', $email)
                ->where('role', 'admin')
                ->first();

            if (! $admin || ! password_verify($password, $admin['password_hash'])) {
                // Admin tidak ditemukan atau password salah
                return redirect()->back()->withInput()->with('errors', ['login' => 'Email atau kata sandi salah.']);
            }

            // Simpan identitas admin minimal ke sesi
            session()->set([
                'admin_id'    => $admin['id'],
                'admin_name'  => $admin['name'],
                'admin_email' => $admin['email'],
                'logged_in'  => true,
            ]);

            return redirect()->to(base_url('admin/dashboard'))
                ->with('message', 'Selamat datang kembali, ' . $admin['name'] . '!');
        }

        return view('login');
    }

    public function logout()
    {
        session()->destroy();
        return redirect()->to(base_url('login'));
    }
}
